/*
 * Decompiled with CFR 0.152.
 */
package ballworld;

import ballworld.Ball;
import ballworld.BallWorld;
import cs101.lang.Animate;
import cs101.lang.AnimatorThread;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;

public class BallRenderer {
    private Ball myBall;
    private BallWorld myWorld;
    private AnimatorThread at;
    private boolean selected;

    public BallRenderer(Ball ball, BallWorld ballWorld) {
        this.myBall = ball;
        this.myWorld = ballWorld;
        if (ball instanceof Animate) {
            this.at = new AnimatorThread((Animate)((Object)ball), true, 0L, 50L);
        }
    }

    public void drawBall(Graphics2D graphics2D) {
        double d = this.myBall.getRadius();
        double d2 = d * 2.0;
        Point point = new Point();
        point.setLocation(this.myBall.getX(), this.myBall.getY());
        Point point2 = BallRenderer.transformWorld2GUI(point, this.myWorld);
        double d3 = point2.getX();
        double d4 = point2.getY();
        Ellipse2D.Double double_ = new Ellipse2D.Double(d3 - d, d4 - d, d2, d2);
        if (this.selected) {
            graphics2D.setPaint(Color.red);
        } else {
            graphics2D.setPaint(Color.black);
        }
        graphics2D.fill(double_);
    }

    public Ball getBall() {
        return this.myBall;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean containsPoint(Point point) {
        return this.distanceTo(point) <= this.myBall.getRadius();
    }

    public double distanceTo(Point point) {
        double d = this.myBall.getX();
        double d2 = this.myBall.getY();
        double d3 = point.getX();
        double d4 = point.getY();
        return Math.pow(Math.pow(d - d3, 2.0) + Math.pow(d2 - d4, 2.0), 0.5);
    }

    public void stop() {
        this.at.stopExecution();
    }

    public static Point transformWorld2GUI(Point point, BallWorld ballWorld) {
        Point point2 = new Point();
        double d = ballWorld.getGUIMaxY();
        double d2 = ballWorld.getGUIMaxX();
        point2.setLocation(point.getX() + d2 / 2.0, d / 2.0 - point.getY());
        return point2;
    }

    public static Point transformGUI2World(Point point, BallWorld ballWorld) {
        Point point2 = new Point();
        double d = ballWorld.getGUIMaxY();
        double d2 = ballWorld.getGUIMaxX();
        point2.setLocation(point.getX() - d2 / 2.0, d / 2.0 - point.getY());
        return point2;
    }
}

