/*
 * Decompiled with CFR 0.152.
 */
package ballworld;

import ballworld.Ball;
import ballworld.BallRenderer;
import ballworld.World;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;

public class BallWorld
extends JComponent
implements World,
Runnable {
    private BallRenderer selectedBall;
    private BufferedImage background;
    private Vector ballList;
    private boolean running;
    private ClassLoader cl = Thread.currentThread().getContextClassLoader();

    public BallWorld() {
        this.ballList = new Vector();
        URL uRL = this.cl.getResource("IMAGES/grass.jpg");
        this.background = this.loadBufferedImage(uRL);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BallWorld.this.processClick(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                BallWorld.this.processClick(mouseEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                BallWorld.this.processKey(keyEvent);
            }
        });
    }

    private BufferedImage loadBufferedImage(URL uRL) {
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Image load interrupted for background!\n" + interruptedException);
        }
        int n = image.getHeight(this);
        int n2 = image.getWidth(this);
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, this);
        return bufferedImage;
    }

    public void paint(Graphics graphics) {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        TexturePaint texturePaint = new TexturePaint(this.background, new Rectangle(0, 0, this.background.getWidth(), this.background.getHeight()));
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        graphics2D.drawOval(10, 10, 30, 30);
        graphics2D.setPaint(texturePaint);
        graphics2D.fill(rectangle);
        graphics2D.setPaint(Color.black);
        for (int i = 0; i < this.ballList.size(); ++i) {
            ((BallRenderer)this.ballList.get(i)).drawBall(graphics2D);
        }
        graphics.drawImage(bufferedImage, 0, 0, this);
    }

    public void addBallRenderer(BallRenderer ballRenderer) {
        this.requestFocus();
        this.selectBall(ballRenderer);
        this.ballList.add(ballRenderer);
    }

    public void removeBallRenderer(BallRenderer ballRenderer) {
        ballRenderer.stop();
        this.ballList.remove(ballRenderer);
    }

    public synchronized void addBall(Ball ball) {
        ball.setWorld(this);
        this.addBallRenderer(new BallRenderer(ball, this));
    }

    public Ball getClosestBall(Ball ball) {
        Point point = new Point();
        point.setLocation(ball.getX(), ball.getY());
        Ball ball2 = this.nearestBall(point, this.ballList).getBall();
        return ball2 == ball ? null : ball2;
    }

    public double getMaxX() {
        return this.getWidth() / 2;
    }

    public double getMaxY() {
        return this.getHeight() / 2;
    }

    public double getGUIMaxX() {
        return this.getWidth();
    }

    public double getGUIMaxY() {
        return this.getHeight();
    }

    public double getMinX() {
        return -this.getWidth() / 2;
    }

    public double getMinY() {
        return -this.getHeight() / 2;
    }

    public synchronized void removeBall(Ball ball) {
        for (int i = 0; i < this.ballList.size(); ++i) {
            if (!((BallRenderer)this.ballList.get(i)).getBall().equals(ball)) continue;
            this.removeBallRenderer((BallRenderer)this.ballList.get(i));
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            this.repaint();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Ball World thread interrupted");
            }
        }
    }

    public void stop() {
        this.running = false;
    }

    private void processClick(MouseEvent mouseEvent) {
        Point point;
        Cloneable cloneable;
        if (mouseEvent.getID() == 501) {
            cloneable = new Vector();
            point = new Point();
            point.setLocation(mouseEvent.getX(), mouseEvent.getY());
            Point point2 = BallRenderer.transformGUI2World(point, this);
            for (int i = 0; i < this.ballList.size(); ++i) {
                BallRenderer ballRenderer = (BallRenderer)this.ballList.get(i);
                if (!ballRenderer.containsPoint(point2)) continue;
                ((Vector)cloneable).add(ballRenderer);
            }
            BallRenderer ballRenderer = this.nearestBall(point2, (Vector)cloneable);
            if (ballRenderer != null) {
                this.selectBall(ballRenderer);
            } else if (this.selectedBall != null) {
                this.selectedBall.setSelected(false);
                this.selectedBall = null;
            }
        }
        if (mouseEvent.getID() == 502) {
            cloneable = new Point();
            ((Point)cloneable).setLocation(mouseEvent.getX(), mouseEvent.getY());
            point = BallRenderer.transformGUI2World((Point)cloneable, this);
            if (this.selectedBall != null) {
                this.selectedBall.getBall().userClicked(point.getX(), point.getY());
            }
        }
        this.requestFocus();
    }

    private void processKey(KeyEvent keyEvent) {
        if (this.selectedBall != null) {
            this.selectedBall.getBall().userTyped(keyEvent.getKeyChar());
        }
    }

    private synchronized BallRenderer nearestBall(Point point, Vector vector) {
        if (vector.size() == 0) {
            return null;
        }
        BallRenderer ballRenderer = (BallRenderer)vector.get(0);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            BallRenderer ballRenderer2 = (BallRenderer)iterator.next();
            if (!(ballRenderer.distanceTo(point) > ballRenderer2.distanceTo(point))) continue;
            ballRenderer = ballRenderer2;
        }
        return ballRenderer;
    }

    private void selectBall(BallRenderer ballRenderer) {
        if (this.selectedBall != null) {
            this.selectedBall.setSelected(false);
        }
        this.selectedBall = ballRenderer;
        ballRenderer.setSelected(true);
    }
}

