/*
 * Decompiled with CFR 0.152.
 */
package ballworld;

import ballworld.Ball;
import ballworld.BallWorld;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class BallWorldGUI
extends JFrame {
    BallWorld ourWorld;
    Thread spaceTime;
    ClassLoader cl = Thread.currentThread().getContextClassLoader();
    URLClassLoader uLoad = new URLClassLoader(new URL[0], this.cl);
    private JPanel buttonPanel;
    private JMenuItem exitMenuItem;
    private JMenuItem expandClasspathMenuItem;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JMenuItem loadMenuItem;
    private JPanel worldPanel;

    public BallWorldGUI() {
        this.ourWorld = new BallWorld();
        this.initComponents();
        this.spaceTime = new Thread(this.ourWorld);
        this.spaceTime.start();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.worldPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadMenuItem = new JMenuItem();
        this.expandClasspathMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setTitle("Ball World");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BallWorldGUI.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.worldPanel.setLayout(new GridLayout(1, 0));
        this.worldPanel.add(this.ourWorld);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.worldPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.buttonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.fileMenu.setText("File");
        this.loadMenuItem.setText("Load Ball...");
        this.loadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BallWorldGUI.this.loadMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.expandClasspathMenuItem.setText("Expand Classpath...");
        this.expandClasspathMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BallWorldGUI.this.expandClasspathMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.expandClasspathMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BallWorldGUI.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 400) / 2, (dimension.height - 500) / 2, 400, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandClasspathMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = "";
        try {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                public String getDescription() {
                    return "Java Archive (*.jar) or Directory";
                }

                public boolean accept(File file) {
                    return file.getName().matches(".*\\.jar") || file.isDirectory();
                }
            });
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            int n2 = jFileChooser.showOpenDialog(this);
            File[] fileArray = jFileChooser.getSelectedFiles();
            URL[] uRLArray = this.uLoad.getURLs();
            URL[] uRLArray2 = new URL[uRLArray.length + fileArray.length];
            for (n = 0; n < fileArray.length; ++n) {
                uRLArray2[n] = fileArray[n].toURL();
            }
            for (n = fileArray.length; n < uRLArray2.length; ++n) {
                uRLArray2[n] = uRLArray[n - fileArray.length];
            }
            URLClassLoader uRLClassLoader = this.uLoad;
            synchronized (uRLClassLoader) {
                this.uLoad = new URLClassLoader(uRLArray2, this.cl);
            }
        }
        catch (AccessControlException accessControlException) {
            this.showAppletWarning();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadMenuItemActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        String string = JOptionPane.showInputDialog("Enter the fully qualified name of a class");
        if (string == null) {
            return;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        try {
            clazz = Class.forName(string, true, this.uLoad);
            objectArray = clazz.getConstructors();
            for (int i = 0; i < objectArray.length; ++i) {
                System.out.println(objectArray[i].toString());
                Class<?>[] classArray = objectArray[i].getParameterTypes();
                for (int j = 0; j < classArray.length; ++j) {
                    String string3 = classArray[j].getName();
                    if (!string3.equals("ballworld.World")) continue;
                    constructor = objectArray[i];
                }
                if (classArray.length != 0) continue;
                constructor2 = objectArray[i];
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("ballworld." + string, true, this.uLoad);
                Constructor<?>[] constructorArray = clazz.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    System.out.println(constructorArray[i].toString());
                    Class<?>[] classArray = constructorArray[i].getParameterTypes();
                    for (int j = 0; j < classArray.length; ++j) {
                        String string4 = classArray[j].getName();
                        if (!string4.equals("ballworld.World")) continue;
                        constructor = constructorArray[i];
                    }
                    if (classArray.length != 0) continue;
                    constructor2 = constructorArray[i];
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                JOptionPane.showMessageDialog(this, "Class not found!", "Warning", 0);
                System.out.println("Warning student class not found");
            }
        }
        Constructor<?> constructor3 = null;
        if (constructor != null) {
            constructor3 = constructor;
            objectArray = new Object[]{this.ourWorld};
        } else if (constructor2 != null) {
            constructor3 = constructor2;
            objectArray = new Object[]{};
        } else {
            JOptionPane.showMessageDialog(this, "No Valid Constructor!", "Warning", 0);
            System.out.println("Class must have a constructor that takes zero arguments or takes\njust one argument of type ballworld.World");
            return;
        }
        final Constructor<?> constructor4 = constructor3;
        final Object[] objectArray2 = objectArray;
        System.out.println("Constructor selected = " + constructor4);
        JButton jButton = new JButton(string2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ball ball = null;
                try {
                    ball = (Ball)constructor4.newInstance(objectArray2);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("Failed to instantiate the ball");
                    System.out.println(instantiationException);
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Illegal access instantiating ball");
                    System.out.println(illegalAccessException);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("Failed to instantiate the ball");
                    System.out.println(invocationTargetException);
                    return;
                }
                BallWorldGUI.this.ourWorld.addBall(ball);
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Component component = (Component)mouseEvent.getSource();
                Container container = component.getParent();
                if ((mouseEvent.getModifiers() & 2) != 0) {
                    BallWorldGUI.this.buttonPanel.remove(component);
                    container.getParent().validate();
                }
            }
        });
        this.buttonPanel.add(jButton);
        this.validate();
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.exitForm(new WindowEvent(this, 201));
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void showAppletWarning() {
        Object[] objectArray = new Object[]{"Cancel"};
        JOptionPane.showOptionDialog(null, "This action not available when running as an applet.", "Network Simulation", -1, 2, null, objectArray, objectArray[0]);
    }

    public static void main(String[] stringArray) {
        new BallWorldGUI().show();
    }
}

