/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class NetworkSettingsDialog
extends JDialog {
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_CLIENT = 1;
    public static final int NETWORK_SERVER = 2;
    private int mode = 0;
    private static boolean debug;
    private JRadioButton clientRadioButton;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel leftPanel;
    private ButtonGroup modeButtons;
    private JButton okButton;
    private JLabel portLabel;
    private JTextField portTextField;
    private JRadioButton serverRadioButton;
    private JRadioButton standaloneRadioButton;

    public NetworkSettingsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.modeButtons = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.leftPanel = new JPanel();
        this.standaloneRadioButton = new JRadioButton();
        this.clientRadioButton = new JRadioButton();
        this.serverRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.okButton = new JButton();
        this.jLabel3.setText("jLabel3");
        this.setTitle("Network Settings");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NetworkSettingsDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.leftPanel.setBorder(new TitledBorder("Mode"));
        this.standaloneRadioButton.setText(" Standalone");
        this.standaloneRadioButton.setToolTipText("Run with no network features enabled");
        this.modeButtons.add(this.standaloneRadioButton);
        this.standaloneRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.standaloneRadioButtonActionPerformed(actionEvent);
            }
        });
        this.leftPanel.add(this.standaloneRadioButton);
        this.clientRadioButton.setText("Client");
        this.clientRadioButton.setToolTipText("Run as a networked client");
        this.modeButtons.add(this.clientRadioButton);
        this.clientRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.clientRadioButtonActionPerformed(actionEvent);
            }
        });
        this.leftPanel.add(this.clientRadioButton);
        this.serverRadioButton.setText("Server");
        this.serverRadioButton.setToolTipText("Run as a networked server");
        this.modeButtons.add(this.serverRadioButton);
        this.serverRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.serverRadioButtonActionPerformed(actionEvent);
            }
        });
        this.leftPanel.add(this.serverRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.leftPanel, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.hostLabel.setText("Host:");
        this.hostLabel.setToolTipText("The host to connect to");
        this.hostLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.hostLabel, gridBagConstraints);
        this.hostTextField.setText("localhost");
        this.hostTextField.setToolTipText("Enter the host name here");
        this.hostTextField.setPreferredSize(new Dimension(100, 19));
        this.hostTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.hostTextField, gridBagConstraints);
        this.portLabel.setText("Port:");
        this.portLabel.setToolTipText("The port to listen on or connect to");
        this.portLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.portLabel, gridBagConstraints);
        this.portTextField.setText("4321");
        this.portTextField.setToolTipText("Enter the port number here");
        this.portTextField.setPreferredSize(new Dimension(100, 19));
        this.portTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.portTextField, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.setMargin(new Insets(2, 28, 2, 28));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.validateInput()) {
            return;
        }
        this.hide();
        System.out.println("getMode() will return: " + this.getMode());
        if (debug) {
            try {
                System.out.println("getHost() will return: " + this.getHost());
            }
            catch (RuntimeException runtimeException) {
                System.out.println("getHost() will throw " + runtimeException);
            }
            try {
                System.out.println("getPort() will return: " + this.getPort());
            }
            catch (RuntimeException runtimeException) {
                System.out.println("getPort() will throw " + runtimeException);
            }
        }
    }

    private void standaloneRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.mode = 0;
        this.hostLabel.setEnabled(false);
        this.hostTextField.setEnabled(false);
        this.portLabel.setEnabled(false);
        this.portTextField.setEnabled(false);
    }

    private void clientRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.mode = 1;
        this.hostLabel.setEnabled(true);
        this.hostTextField.setEnabled(true);
        this.portLabel.setEnabled(true);
        this.portTextField.setEnabled(true);
    }

    private void serverRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.mode = 2;
        this.hostLabel.setEnabled(false);
        this.hostTextField.setEnabled(false);
        this.portLabel.setEnabled(true);
        this.portTextField.setEnabled(true);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private boolean validateInput() {
        try {
            if (this.mode == 1) {
                Integer.parseInt(this.portTextField.getText());
                InetAddress.getByName(this.hostTextField.getText());
            } else if (this.mode == 2) {
                Integer.parseInt(this.portTextField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Non-numeric value for port!");
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this, "Unknown host: " + this.hostTextField.getText());
            return false;
        }
        return true;
    }

    public int getMode() {
        return this.mode;
    }

    public int getPort() {
        if (this.mode == 0) {
            throw new RuntimeException("Invalid Network settings for getPort()");
        }
        return Integer.parseInt(this.portTextField.getText());
    }

    public String getHost() {
        if (this.mode == 1) {
            return this.hostTextField.getText();
        }
        throw new RuntimeException("Invalid Network settings for getHost()");
    }

    public static void main(String[] stringArray) {
        debug = true;
        NetworkSettingsDialog networkSettingsDialog = new NetworkSettingsDialog((Frame)new JFrame(), true);
        networkSettingsDialog.show();
        System.exit(0);
    }
}

