/*
 * Decompiled with CFR 0.152.
 */
package cs101.util.queue;

import cs101.util.queue.EmptyQueueException;
import cs101.util.queue.Queue;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class DefaultQueue
implements Queue {
    private Link first;
    private Link last;
    private int count;

    public DefaultQueue() {
    }

    public DefaultQueue(Object object) {
        this.first = this.last = new Link(object);
        this.count = 1;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized Object peek() {
        return this.peek(1);
    }

    public synchronized Object peek(int n) {
        if (this.isEmpty()) {
            throw new EmptyQueueException();
        }
        if (n == 0) {
            return this.first.contents();
        }
        return this.last.contents();
    }

    public synchronized void enqueue(Object object) {
        this.enqueue(object, 0);
    }

    public synchronized void enqueue(Object object, int n) {
        if (this.isEmpty()) {
            this.first = this.last = new Link(object);
        } else if (n == 0) {
            Link link = new Link(object);
            link.setNext(this.first);
            this.first.setPrevious(link);
            this.first = link;
        } else {
            Link link = new Link(object);
            link.setPrevious(this.last);
            this.last.setNext(link);
            this.last = link;
        }
        ++this.count;
    }

    public synchronized Object dequeue() {
        return this.dequeue(1);
    }

    public synchronized Object dequeue(int n) {
        if (this.isEmpty()) {
            throw new EmptyQueueException();
        }
        --this.count;
        if (n == 0) {
            Object object = this.first.contents();
            Link link = this.first.next();
            this.first.setNext(null);
            this.first = link;
            if (this.first == null) {
                this.last = null;
            } else {
                this.first.setPrevious(null);
            }
            return object;
        }
        Object object = this.last.contents();
        Link link = this.last.previous();
        this.last.setPrevious(null);
        this.last = link;
        if (this.last == null) {
            this.first = null;
        } else {
            this.last.setNext(null);
        }
        return object;
    }

    public synchronized boolean isEmpty() {
        return this.first == null;
    }

    public Enumeration elements() {
        return new QueueEnumeration(this.first);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("cs101.util.Queue: [");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    class Link {
        private Link previous = null;
        private Link next = null;
        private Object contents;

        protected Link(Object object) {
            this.contents = object;
        }

        public Object contents() {
            return this.contents;
        }

        public Link next() {
            return this.next;
        }

        public Link previous() {
            return this.previous;
        }

        protected synchronized void setPrevious(Link link) {
            this.previous = link;
        }

        protected synchronized void setNext(Link link) {
            this.next = link;
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer("cs101.util.Link: [previous:");
            if (this.previous != null) {
                stringBuffer.append("linked");
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append("] [contents:" + this.contents + "] [next:");
            if (this.next != null) {
                stringBuffer.append("linked]");
            } else {
                stringBuffer.append("null]");
            }
            return stringBuffer.toString();
        }
    }

    private class QueueEnumeration
    implements Enumeration {
        private Link current;

        public QueueEnumeration(Link link) {
            this.current = link;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.current.contents();
            this.current = this.current.next();
            return object;
        }
    }
}

