/*
 * Decompiled with CFR 0.152.
 */
package cs101.util.semaphore;

import cs101.awt.ColorField;
import cs101.util.semaphore.GraphicalSemaphore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;

public class GCS
extends GraphicalSemaphore {
    private int size;
    private int busy;
    private ColorField[] fields;

    public GCS(int n, int n2, String string) {
        super(string);
        this.size = n;
        this.busy = n2 - 1;
        if (this.busy >= this.size) {
            this.busy = this.size - 1;
        }
        if (this.busy < -1) {
            this.busy = -1;
        }
        this.setupGUI();
    }

    protected void setupGUI() {
        this.fields = new ColorField[this.size];
        this.display = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.display.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1 / this.size;
        for (int i = 0; i < this.size; ++i) {
            this.fields[i] = i <= this.busy ? new ColorField(true, new Dimension(25, 10), Color.red, Color.green) : new ColorField(false, new Dimension(25, 10), Color.red, Color.green);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagLayout.setConstraints(this.fields[i], gridBagConstraints);
            this.display.add(this.fields[i]);
        }
        super.setupGUI();
    }

    public synchronized void request() {
        while (this.busy == this.size - 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.busy;
        this.showStatus();
    }

    public synchronized void release() {
        if (this.busy >= 0) {
            --this.busy;
            this.notifyAll();
            this.showStatus();
        }
    }

    protected void showStatus() {
        int n;
        for (n = 0; n < this.myNumber; ++n) {
            System.out.print("               ");
        }
        System.out.print(this.label.getText() + ": ");
        System.out.println(this.busy + 1);
        for (n = 0; n < this.size; ++n) {
            if (n <= this.busy) {
                this.fields[n].changeState(true);
                continue;
            }
            this.fields[n].changeState(false);
        }
    }
}

