/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt;

import cs101.util.queue.DefaultQueue;
import cs101.util.queue.EmptyQueueException;
import cs101.util.queue.Queue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;

public class Console
extends Frame {
    private Queue inputLines = new DefaultQueue();
    private TextArea ta = new TextArea("", 24, 80, 0);

    public Console() {
        super("CS101 Console");
        this.ta.setFont(new Font("Monospaced", 0, 10));
        this.ta.addKeyListener(new ConsoleKeyAdapter(this));
        this.add("Center", this.ta);
        this.pack();
        this.show();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(ActionEvent actionEvent) {
                Console.this.setVisible(false);
            }
        });
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        this.ta.append(string);
    }

    public String readln() {
        boolean bl = false;
        String string = "";
        while (!bl) {
            try {
                string = (String)this.inputLines.dequeue();
                bl = true;
            }
            catch (EmptyQueueException emptyQueueException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return string;
    }

    void addInputLine(String string) {
        this.inputLines.enqueue(string);
    }

    class ConsoleKeyAdapter
    extends KeyAdapter {
        private Console myConsole;
        private StringBuffer curInputLine;

        public ConsoleKeyAdapter(Console console2) {
            this.myConsole = console2;
            this.curInputLine = new StringBuffer();
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\b' && this.curInputLine.length() > 0) {
                this.curInputLine.deleteCharAt(this.curInputLine.length() - 1);
                return;
            }
            if (c == '\n') {
                this.myConsole.addInputLine(this.curInputLine.toString());
                this.curInputLine = new StringBuffer();
            } else {
                if (keyEvent.isActionKey()) {
                    return;
                }
                this.curInputLine.append(c);
            }
        }
    }
}

