/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt.geom;

import cs101.awt.geom.NoUniqueLineException;
import cs101.awt.geom.NotEnoughPointsException;
import cs101.awt.geom.PointIterator;
import cs101.awt.geom.ShapesDontOverlapException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public final class ShapeUtils {
    private ShapeUtils() {
    }

    public static Line2D.Float bounce(Line2D.Float float_, Line2D.Float float_2) {
        AffineTransform affineTransform;
        double d = ShapeUtils.angleToVert(float_);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d);
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.out.println("NoninvertableTransformException! bounce not calculated.");
            throw new Error("Rotations shoud be invertable!");
        }
        Shape shape = affineTransform2.createTransformedShape(float_2);
        PointIterator pointIterator = new PointIterator(shape);
        float_2 = new Line2D.Float(pointIterator.nextPoint(), pointIterator.nextPoint());
        float_2.setLine(0.0, 0.0, -float_2.getX2(), float_2.getY2());
        shape = affineTransform.createTransformedShape(float_2);
        pointIterator = new PointIterator(shape);
        float_2 = new Line2D.Float(pointIterator.nextPoint(), pointIterator.nextPoint());
        return float_2;
    }

    public static Line2D.Float doReflect(Shape shape, Shape shape2, double d, double d2) {
        Point2D.Float float_;
        if (!ShapeUtils.isOverlapping(shape, shape2)) {
            throw new ShapesDontOverlapException("Cannot reflect shapes untilthey hit each other");
        }
        Line2D.Float float_2 = null;
        Line2D.Float float_3 = new Line2D.Float(0.0f, 0.0f, new Double(d).floatValue(), new Double(d2).floatValue());
        try {
            float_ = ShapeUtils.meanContainedPoint(shape2, shape);
        }
        catch (NotEnoughPointsException notEnoughPointsException) {
            try {
                float_ = ShapeUtils.meanContainedPoint(shape, shape2);
            }
            catch (NotEnoughPointsException notEnoughPointsException2) {
                throw new Error("overlapping but neither conatins the other point!");
            }
        }
        try {
            float_2 = ShapeUtils.nearestSegment(shape2, float_);
        }
        catch (NotEnoughPointsException notEnoughPointsException) {
            System.out.println("Ignoring malformed shape:" + notEnoughPointsException.getMessage());
            return float_3;
        }
        catch (NoUniqueLineException noUniqueLineException) {
            Point2D.Float float_4 = ShapeUtils.getNearestPoint(shape, float_);
            float_2 = ShapeUtils.getLineFromNeighbors(shape, float_4);
        }
        return ShapeUtils.bounce(float_2, float_3);
    }

    public static Line2D.Float doReflect(Shape shape, Shape shape2, Line2D.Float float_) {
        return ShapeUtils.doReflect(shape, shape2, float_.getX2(), float_.getY2());
    }

    public static double doXReflect(Shape shape, Shape shape2, double d, double d2) {
        return ShapeUtils.doReflect(shape, shape2, d, d2).getX2();
    }

    public static double doYReflect(Shape shape, Shape shape2, double d, double d2) {
        return ShapeUtils.doReflect(shape, shape2, d, d2).getY2();
    }

    public static double angleToVert(Line2D.Float float_) {
        Point2D.Float float_2 = new Point2D.Float();
        Point2D.Float float_3 = new Point2D.Float();
        float_2.setLocation(float_.getX1(), float_.getY1());
        float_3.setLocation(float_.getX2(), float_.getY2());
        double d = float_2.y - float_3.y;
        double d2 = float_2.x - float_3.x;
        double d3 = d / d2;
        return 1.5707963267948966 - Math.atan(d3);
    }

    public static Line2D.Float getLineFromNeighbors(Shape shape, Point2D.Float float_) {
        Point2D.Float float_2;
        PointIterator pointIterator = new PointIterator(shape);
        Point2D.Float float_3 = null;
        Point2D.Float float_4 = null;
        Point2D.Float float_5 = null;
        Point2D.Float float_6 = float_2 = pointIterator.nextPoint();
        while (pointIterator.hasNext() && pointIterator.isStart(float_6)) {
            if (float_6.equals(float_)) {
                if (pointIterator.hasNext()) {
                    float_2 = float_4 = pointIterator.nextPoint();
                } else {
                    throw new IllegalArgumentException("Shape has only one Point!");
                }
                while (pointIterator.hasNext() && pointIterator.isStart(float_6) && float_2 != float_6) {
                    float_5 = float_2;
                    float_2 = pointIterator.nextPoint();
                }
                if (float_2 == float_6) {
                    return new Line2D.Float(float_5, float_4);
                }
                return new Line2D.Float(float_6, float_4);
            }
            float_5 = float_2;
            float_2 = pointIterator.nextPoint();
            if (!float_2.equals(float_)) continue;
            float_3 = float_5;
            if (pointIterator.hasNext()) {
                float_2 = pointIterator.nextPoint();
            }
            return new Line2D.Float(float_3, float_2);
        }
        throw new IllegalArgumentException("Point was not a knot of the supplied Shape");
    }

    public static Point2D.Float getNearestPoint(Shape shape, Point2D.Float float_) {
        Point2D.Float float_2 = null;
        Point2D.Float float_3 = null;
        PointIterator pointIterator = new PointIterator(shape);
        float_2 = pointIterator.nextPoint();
        while (pointIterator.hasNext()) {
            float_3 = pointIterator.nextPoint();
            if (!(float_.distance(float_2) > float_.distance(float_3))) continue;
            float_2 = float_3;
        }
        return float_2;
    }

    public static Line2D.Float nearestSegment(Shape shape, Point2D.Float float_) throws NoUniqueLineException, NotEnoughPointsException {
        PointIterator pointIterator = new PointIterator(shape);
        Point2D.Float float_2 = null;
        Point2D.Float float_3 = null;
        Line2D.Float float_4 = null;
        Line2D.Float float_5 = null;
        Line2D.Float float_6 = null;
        double d = -1.0;
        double d2 = -1.0;
        if (pointIterator.hasNext()) {
            float_2 = pointIterator.nextPoint();
        }
        if (pointIterator.hasNext()) {
            float_3 = pointIterator.nextPoint();
        }
        if (float_2 == null || float_3 == null) {
            throw new NotEnoughPointsException("Not enough points for a line");
        }
        if (float_2.equals(float_3) && !pointIterator.hasNext()) {
            throw new NotEnoughPointsException("Only two duplicate points");
        }
        float_4 = new Line2D.Float(float_2, float_3);
        d = float_4.ptSegDist(float_);
        while (pointIterator.hasNext()) {
            float_2 = float_3;
            if (float_2.equals(float_3 = pointIterator.nextPoint())) continue;
            float_6 = new Line2D.Float(float_2, float_3);
            double d3 = float_6.ptSegDist(float_);
            if (float_5 == null) {
                float_5 = float_6;
                d2 = d3;
            }
            if (d == d3) {
                float_5 = float_6;
                d2 = d3;
                continue;
            }
            if (!(d > d3)) continue;
            float_5 = float_4;
            d2 = d;
            float_4 = float_6;
            d = d3;
        }
        if (float_5 == null) {
            throw new NotEnoughPointsException("Only duplicate points found");
        }
        if (d == d2) {
            throw new NoUniqueLineException("More than one Line");
        }
        return float_4;
    }

    public static Point2D.Float meanPoint(List list) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            d += (double)((Point2D.Float)list.get((int)i)).x;
            d2 += (double)((Point2D.Float)list.get((int)i)).y;
        }
        float f = new Double(d / (double)list.size()).floatValue();
        float f2 = new Double(d2 / (double)list.size()).floatValue();
        return new Point2D.Float(f, f2);
    }

    public static Point2D.Float meanContainedPoint(Shape shape, Shape shape2) throws NotEnoughPointsException {
        ArrayList arrayList = ShapeUtils.getContainedPoints(shape, shape2);
        if (arrayList.size() == 0) {
            throw new NotEnoughPointsException("no points contained by container");
        }
        return ShapeUtils.meanPoint(arrayList);
    }

    public static ArrayList getContainedPoints(Shape shape, Shape shape2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PointIterator pointIterator = new PointIterator(shape2);
        while (pointIterator.hasNext()) {
            Point2D.Float float_ = pointIterator.nextPoint();
            if (!shape.contains(float_.x, float_.y)) continue;
            arrayList.add(float_.clone());
        }
        return arrayList;
    }

    public static boolean isOverlapping(Shape shape, Shape shape2) {
        Point2D.Float float_;
        Rectangle rectangle;
        PointIterator pointIterator = new PointIterator(shape);
        PointIterator pointIterator2 = new PointIterator(shape2);
        Rectangle rectangle2 = shape.getBounds();
        if (!rectangle2.intersects(rectangle = shape2.getBounds())) {
            return false;
        }
        while (pointIterator.hasNext()) {
            float_ = pointIterator.nextPoint();
            if (!shape2.contains(float_.x, float_.y)) continue;
            return true;
        }
        while (pointIterator2.hasNext()) {
            float_ = pointIterator2.nextPoint();
            if (!shape.contains(float_.x, float_.y)) continue;
            return true;
        }
        return false;
    }

    public static Shape getPreciseShape(Shape shape, float f) {
        GeneralPath generalPath = new GeneralPath(shape);
        GeneralPath generalPath2 = ShapeUtils.getPrecisePath(generalPath, f);
        return generalPath == generalPath2 ? shape : generalPath2;
    }

    public static GeneralPath getPrecisePath(GeneralPath generalPath, float f) {
        GeneralPath[] generalPathArray = new GeneralPath[2];
        generalPathArray[0] = generalPath;
        while (generalPathArray[0] != generalPathArray[1]) {
            generalPathArray[1] = generalPathArray[0];
            generalPathArray[0] = ShapeUtils.getImprovedPath(generalPathArray[0], f);
        }
        return generalPathArray[0];
    }

    public static GeneralPath getImprovedPath(GeneralPath generalPath, float f) {
        GeneralPath generalPath2 = new GeneralPath();
        PathIterator pathIterator = generalPath.getPathIterator(null);
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        Point2D.Float float_3 = new Point2D.Float();
        Point2D.Float float_4 = new Point2D.Float();
        Point2D.Float float_5 = new Point2D.Float();
        float[] fArray = new float[12];
        boolean bl = false;
        boolean bl2 = false;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            pathIterator.next();
            switch (n) {
                case 0: {
                    bl2 = false;
                    float_5.setLocation(fArray[0], fArray[1]);
                    float_.setLocation(fArray[0], fArray[1]);
                    float_4.setLocation(fArray[0], fArray[1]);
                    generalPath2.moveTo(float_4.x, float_4.y);
                    break;
                }
                case 4: {
                    if (bl2) {
                        throw new IllegalPathStateException("Path closed twice!");
                    }
                    float_4.x = float_5.x;
                    float_4.y = float_5.y;
                    bl2 = true;
                    if (float_.distance(float_4) <= (double)f) {
                        generalPath2.closePath();
                        break;
                    }
                    bl = true;
                    fArray[0] = float_4.x;
                    fArray[1] = float_4.y;
                    ShapeUtils.createIntermediateLine(float_, fArray);
                    generalPath2.lineTo(fArray[0], fArray[1]);
                    generalPath2.closePath();
                    break;
                }
                case 1: {
                    if (bl2) {
                        throw new IllegalPathStateException("Path already closed!");
                    }
                    float_4.setLocation(fArray[0], fArray[1]);
                    if (float_.distance(float_4) <= (double)f) {
                        generalPath2.lineTo(float_4.x, float_4.y);
                        break;
                    }
                    bl = true;
                    ShapeUtils.createIntermediateLine(float_, fArray);
                    generalPath2.lineTo(fArray[0], fArray[1]);
                    generalPath2.lineTo(fArray[2], fArray[3]);
                    break;
                }
                case 2: {
                    if (bl2) {
                        throw new IllegalPathStateException("Path already closed!");
                    }
                    float_2.setLocation(fArray[0], fArray[1]);
                    float_4.setLocation(fArray[2], fArray[3]);
                    if (float_.distance(float_4) <= (double)f) {
                        generalPath2.quadTo(float_2.x, float_2.y, float_4.x, float_4.y);
                        break;
                    }
                    bl = true;
                    ShapeUtils.createIntermediateQuad(float_, fArray);
                    generalPath2.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    generalPath2.quadTo(fArray[4], fArray[5], fArray[6], fArray[7]);
                    break;
                }
                case 3: {
                    if (bl2) {
                        throw new IllegalPathStateException("Path already closed!");
                    }
                    float_2.setLocation(fArray[0], fArray[1]);
                    float_3.setLocation(fArray[2], fArray[3]);
                    float_4.setLocation(fArray[4], fArray[5]);
                    if (float_.distance(float_4) <= (double)f) {
                        generalPath2.curveTo(float_2.x, float_2.y, float_3.x, float_3.y, float_4.x, float_4.y);
                        break;
                    }
                    bl = true;
                    ShapeUtils.createIntermediateCurve(float_, fArray);
                    generalPath2.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    generalPath2.curveTo(fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11]);
                    break;
                }
                default: {
                    throw new Error("Unknown segment type from Path Iterator");
                }
            }
            float_.setLocation(float_4.x, float_4.y);
        }
        if (!bl) {
            return generalPath;
        }
        return generalPath2;
    }

    public static void createIntermediateLine(Point2D.Float float_, float[] fArray) {
        Point2D.Float float_2 = ShapeUtils.midPoint(float_.x, float_.y, fArray[0], fArray[1]);
        fArray[2] = fArray[0];
        fArray[3] = fArray[1];
        fArray[0] = float_2.x;
        fArray[1] = float_2.y;
    }

    public static void createIntermediateQuad(Point2D.Float float_, float[] fArray) {
        Point2D.Float float_2 = ShapeUtils.midPoint(float_.x, float_.y, fArray[0], fArray[1]);
        Point2D.Float float_3 = ShapeUtils.midPoint(fArray[0], fArray[1], fArray[2], fArray[3]);
        Point2D.Float float_4 = ShapeUtils.midPoint(float_2.x, float_2.y, float_3.x, float_3.y);
        fArray[6] = fArray[2];
        fArray[7] = fArray[3];
        fArray[0] = float_2.x;
        fArray[1] = float_2.y;
        fArray[2] = float_4.x;
        fArray[3] = float_4.y;
        fArray[4] = float_3.x;
        fArray[5] = float_3.y;
    }

    public static void createIntermediateCurve(Point2D.Float float_, float[] fArray) {
        Point2D.Float float_2 = ShapeUtils.midPoint(float_.x, float_.y, fArray[0], fArray[1]);
        Point2D.Float float_3 = ShapeUtils.midPoint(fArray[2], fArray[3], fArray[4], fArray[5]);
        Point2D.Float float_4 = ShapeUtils.midPoint(fArray[0], fArray[1], fArray[2], fArray[3]);
        Point2D.Float float_5 = ShapeUtils.midPoint(float_2.x, float_2.y, float_4.x, float_4.y);
        Point2D.Float float_6 = ShapeUtils.midPoint(float_4.x, float_4.y, float_3.x, float_3.y);
        Point2D.Float float_7 = ShapeUtils.midPoint(float_5.x, float_5.y, float_6.x, float_6.y);
        fArray[10] = fArray[4];
        fArray[11] = fArray[5];
        fArray[0] = float_2.x;
        fArray[1] = float_2.y;
        fArray[2] = float_5.x;
        fArray[3] = float_5.y;
        fArray[4] = float_7.x;
        fArray[5] = float_7.y;
        fArray[6] = float_6.x;
        fArray[7] = float_6.y;
        fArray[8] = float_3.x;
        fArray[9] = float_3.y;
    }

    public static Point2D.Float midPoint(float f, float f2, float f3, float f4) {
        return new Point2D.Float((f + f3) / 2.0f, (f2 + f4) / 2.0f);
    }
}

