/*
 * Decompiled with CFR 0.152.
 */
package cs101.lang;

import cs101.lang.Animate;

public final class AnimatorThread
extends Thread {
    public static final boolean START_IMMEDIATELY = true;
    public static final boolean DONT_START_YET = false;
    private static final long DEFAULT_SLEEP_MIN_INTERVAL = 200L;
    private static final long DEFAULT_SLEEP_RANGE = 400L;
    private volatile boolean isStopped = false;
    private volatile boolean isSuspended = false;
    private final Object suspendLock = new Object();
    private long sleepMinInterval;
    private long sleepRange;
    private final Animate what;

    public AnimatorThread(Animate animate) {
        this(animate, false);
    }

    public AnimatorThread(Animate animate, boolean bl) {
        this(animate, bl, 200L, 400L);
    }

    public AnimatorThread(Animate animate, long l) {
        this(animate, false, l);
    }

    public AnimatorThread(Animate animate, boolean bl, long l) {
        this(animate, bl, l, 400L);
    }

    public AnimatorThread(Animate animate, long l, long l2) {
        this(animate, false, l, l2);
    }

    public AnimatorThread(Animate animate, boolean bl, long l, long l2) {
        this.what = animate;
        if (this.what == null) {
            throw new IllegalArgumentException("Cannot start an AnimatorThread without supplying an Animate!");
        }
        this.sleepRange = l;
        this.sleepMinInterval = l2;
        if (bl) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: while (!this.isStopped) {
            if (this.isSuspended) {
                Object object = this.suspendLock;
                synchronized (object) {
                    while (this.isSuspended) {
                        try {
                            this.suspendLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.isStopped) continue;
                            break block10;
                        }
                        finally {
                            if (!this.isStopped) continue;
                            break block10;
                        }
                    }
                }
            }
            try {
                Thread.sleep(Math.round(Math.random() * (double)this.sleepRange) + this.sleepMinInterval);
                this.what.act();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void start() {
        this.startExecution();
    }

    public void startExecution() {
        if (!this.isStopped && !this.isAlive()) {
            super.start();
        }
    }

    public void stopExecution() {
        this.isStopped = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendExecution() {
        Object object = this.suspendLock;
        synchronized (object) {
            this.isSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        Object object = this.suspendLock;
        synchronized (object) {
            this.isSuspended = false;
            this.suspendLock.notify();
        }
    }

    public void setSleepMinInterval(long l) {
        this.sleepMinInterval = l;
    }

    public void setSleepRange(long l) {
        this.sleepRange = l;
    }
}

