/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.awt.ClientDialog;
import cs101.util.StringHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.Socket;

public class Client
implements Runnable,
StringHandler {
    protected Thread spirit;
    protected StringHandler stringHandler;
    protected Socket sock;
    protected ObjectInputStream ois;
    protected ObjectOutputStream oos;
    private boolean stopped;

    public Client(String string, int n, StringHandler stringHandler) {
        this.stringHandler = stringHandler;
        this.connectTo(string, n);
    }

    public Client(String string, int n) {
        this.stringHandler = this;
        this.connectTo(string, n);
    }

    public Client(StringHandler stringHandler) {
        this.stringHandler = stringHandler;
        ClientDialog clientDialog = new ClientDialog();
        clientDialog.ask();
        this.connectTo(clientDialog.getHostName(), clientDialog.getPort());
    }

    public Client() {
        this.stringHandler = this;
        ClientDialog clientDialog = new ClientDialog();
        clientDialog.ask();
        this.connectTo(clientDialog.getHostName(), clientDialog.getPort());
    }

    protected void connectTo(String string, int n) {
        System.out.println("Client:  trying to connect to " + string + " on port " + n);
        try {
            this.sock = new Socket(string, n);
            this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            this.ois = new ObjectInputStream(this.sock.getInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Client:  can't establish communication with " + string + " on port " + n);
        }
        this.spirit = new Thread(this);
        this.spirit.start();
    }

    public void run() {
        System.out.println("Client:  starting read loop.");
        try {
            while (!this.stopped) {
                this.stringHandler.handleString((String)this.ois.readObject());
            }
        }
        catch (OptionalDataException optionalDataException) {
            throw new RuntimeException("Client: readObject() failed with OptionalDataException.");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Client:  failed to read");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Client: readObject() failed with ClassNotFoundException.");
        }
    }

    public void send(String string) {
        try {
            this.oos.writeObject(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Client:  failed to send " + string);
        }
    }

    public void setStringHandler(StringHandler stringHandler) {
        this.stringHandler = stringHandler;
    }

    public void handleString(String string) {
        System.out.println("Client:  Got " + string);
        System.out.flush();
    }

    public void finalize() {
        this.stopped = true;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

