/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.awt.ClientDialog;
import cs101.net.Wire;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class ClientWire
implements Wire {
    private Socket sock;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private String hostname;
    private int port;
    private boolean verbose;

    public ClientWire(String string, int n, boolean bl) {
        this.verbose = bl;
        this.connectTo(string, n);
    }

    public ClientWire(String string, int n) {
        this(string, n, true);
    }

    public ClientWire() {
        this.verbose = true;
        ClientDialog clientDialog = new ClientDialog();
        clientDialog.ask();
        this.connectTo(clientDialog.getHostName(), clientDialog.getPort());
    }

    protected void connectTo(String string, int n) {
        if (this.verbose) {
            System.out.println("Client:  trying to connect to " + string + " on port " + n);
        }
        try {
            this.hostname = string;
            this.port = n;
            this.sock = new Socket(string, n);
            this.out = new ObjectOutputStream(this.sock.getOutputStream());
            this.in = new ObjectInputStream(this.sock.getInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Client:  can't establish communication with " + string + " on port " + n);
        }
    }

    public Object readObject() {
        try {
            return this.in.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException("ClientWire:  failed to read from " + this.hostname + " on " + this.port);
        }
    }

    public void writeObject(Object object) {
        try {
            this.out.writeUnshared(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("ClientWire:  failed to write to " + this.hostname + " on " + this.port);
        }
    }

    public void finalize() {
        try {
            this.in.close();
            this.out.close();
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

