/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

public class Coord {
    private Coord other;
    private long lastUpdate = 0L;
    private double lastPos;
    private double pos = 0.0;
    private double posRemainder = 0.0;
    private double vel = 0.0;
    private double accel = 0.0;
    private double maxPos = 400.0;
    private int accelMode = 1;

    public void setOther(Coord coord) {
        if (this.other != null) {
            throw new IllegalStateException("other coord already set!");
        }
        this.other = coord;
    }

    public void startSignal() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public int getMode() {
        return this.accelMode;
    }

    public void setMode(int n) {
        switch (n) {
            case 1: {
                this.setVel(0.0);
            }
            case 2: {
                this.setAccel(0.0);
            }
        }
        this.accelMode = n;
    }

    public double getMaxPos() {
        return this.maxPos;
    }

    public void setMaxPos(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negagive Max Pos!");
        }
        this.maxPos = d;
    }

    public double getPos() {
        return this.pos;
    }

    public double getPosRemainder() {
        double d = this.posRemainder;
        this.posRemainder = 0.0;
        System.out.println(d);
        return d;
    }

    public double doSetPos(double d, boolean bl) {
        if (this.other == null) {
            return 0.0;
        }
        double d2 = d != 0.0 ? d / Math.abs(d) : 1.0;
        this.pos = Math.abs(d) > this.getMaxPos() ? this.getMaxPos() * d2 : d;
        if (bl) {
            this.posRemainder = 0.0;
        }
        return (Math.abs(d) - Math.abs(this.pos)) * d2;
    }

    public void setPos(double d) {
        this.doSetPos(d, true);
    }

    public double getVel() {
        return this.vel;
    }

    public void setVel(double d) {
        this.vel = d;
    }

    public double getAccel() {
        return this.accel;
    }

    public void setAccel(double d) {
        this.accel = d;
    }

    public void setValue(double d) {
        if (this.other == null) {
            return;
        }
        switch (this.accelMode) {
            case 1: {
                this.posRemainder += this.doSetPos(d, false);
                break;
            }
            case 2: {
                this.setVel(d);
                this.nextStep();
                break;
            }
            case 3: {
                this.setAccel(d);
                this.nextStep();
            }
        }
    }

    public double whereNow(long l) {
        double d = (double)(l - this.lastUpdate) / 1000.0;
        double d2 = this.accel * Math.pow(d, 2.0) / 2.0 + this.vel * d + this.pos;
        return d2;
    }

    public void nextStep() {
        long l = System.currentTimeMillis();
        double d = (double)(l - this.lastUpdate) / 1000.0;
        double d2 = this.whereNow(l);
        this.vel += this.accel * d;
        this.doSetPos(d2, false);
        this.lastPos = d2;
        this.lastUpdate = l;
    }
}

