/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import etchasketch.Coord;
import etchasketch.DotPanel;
import etchasketch.EtchControl;
import etchasketch.SetPosGravListener;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class DotFrame
extends Frame {
    private Thread painter;
    private boolean pStarted = false;
    private DotPanel myPanel;
    private Coord x;
    private Coord y;
    private int xDif;
    private int yDif;

    public DotFrame(Coord coord, Coord coord2) {
        this(coord, coord2, EtchControl.DEFAULTFONT);
    }

    public DotFrame(Coord coord, Coord coord2, Font font) {
        this.setFont(font);
        this.myPanel = new DotPanel(coord, coord2);
        this.x = coord;
        this.y = coord2;
        this.setLayout(new BorderLayout(10, 10));
        TextField textField = new TextField(3);
        TextField textField2 = new TextField(3);
        SetPosGravListener setPosGravListener = new SetPosGravListener(this.x, this.y, this.myPanel);
        this.myPanel.addMouseListener(setPosGravListener);
        this.setTitle("Etch-a-Sketch Drawing");
        this.painter = new Thread(this.myPanel);
        this.add("Center", this.myPanel);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = DotFrame.this.getSize().width - DotFrame.this.xDif;
                int n2 = DotFrame.this.getSize().height - DotFrame.this.yDif;
                System.out.println("Resized to " + n + " wide and " + n2 + " high.");
                DotFrame.this.myPanel.setSize(n, n2);
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }
        });
        this.pack();
        this.setVisible(true);
        this.xDif = this.getSize().width - this.myPanel.getSize().width;
        System.out.println("Frame width: " + this.xDif);
        this.yDif = this.getSize().height - this.myPanel.getSize().height;
        System.out.println("Frame height: " + this.yDif);
        System.out.println("Done.");
    }

    public void clearLines() {
        this.myPanel.flushLines();
    }

    public void centerDot() {
        this.x.setPos(0.0);
        this.y.setPos(0.0);
    }

    public void stopDot() {
        this.x.setVel(0.0);
        this.y.setVel(0.0);
    }

    public DotPanel getPanel() {
        return this.myPanel;
    }

    public void suspendPainting() {
        this.myPanel.safeSuspend();
    }

    public void beginPainting() {
        this.x.startSignal();
        this.y.startSignal();
        if (this.pStarted) {
            this.myPanel.safeResume();
        } else {
            this.painter.start();
            this.pStarted = true;
        }
    }

    public void dispose() {
        this.myPanel.safeStop();
        super.dispose();
    }
}

