/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import etchasketch.Coord;
import etchasketch.EtchUtils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class DotPanel
extends Canvas
implements Runnable {
    private Vector v = new Vector(100);
    private Vector grav = new Vector(5);
    private Image buf;
    private Color lineColor = Color.red;
    private Color dotColor = Color.black;
    private Color backgroundColor = Color.white;
    private int width = 400;
    private int height = 400;
    private int loopDelay = 100;
    private Coord x;
    private Coord y;
    private boolean circMode = false;
    private Point focusA = new Point(0, 0);
    private Point focusB = new Point(0, 0);
    private boolean bounceOn = false;
    private boolean wrapOn = false;
    private int myMode = 1;
    private volatile boolean suspended;
    private volatile boolean stop;

    public DotPanel(Coord coord, Coord coord2) {
        this.x = coord;
        this.y = coord2;
        this.setBackground(this.backgroundColor);
    }

    public void setMode(int n) {
        this.myMode = n;
        this.x.setMode(n);
        this.y.setMode(n);
    }

    public void setDelay(int n) {
        this.loopDelay = n < 10 ? 10 : n;
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public double getMaxX() {
        return this.width / 2 - 10;
    }

    public double getMaxY() {
        return this.height / 2 - 10;
    }

    public void safeSuspend() {
        this.suspended = true;
    }

    public void safeStop() {
        this.stop = true;
    }

    public synchronized void safeResume() {
        this.suspended = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            double d;
            double d2;
            double d3 = this.x.getVel();
            double d4 = this.y.getVel();
            if (Math.sqrt(Math.pow(d3, 2.0) + Math.pow(d4, 2.0)) > 120.0) {
                d2 = d3 / Math.abs(d3);
                d = d4 / Math.abs(d4);
                d3 = Math.abs(d3);
                d4 = Math.abs(d4);
                d3 = 120.0 * d3 / (d3 + d4);
                d4 = 120.0 * d4 / (d3 + d4);
                this.x.setVel(d2 * d3);
                this.y.setVel(d * d4);
            }
            d2 = this.x.getPos();
            d = this.y.getPos();
            if (this.bounceOn) {
                double d5 = this.x.getPosRemainder();
                double d6 = this.y.getPosRemainder();
                if (d2 >= this.getMaxX()) {
                    this.x.doSetPos(this.getMaxX() - d5 - 20.0, false);
                    this.x.setVel(-d3);
                }
                if (d2 <= -this.getMaxX()) {
                    this.x.doSetPos(-this.getMaxX() - d5 + 20.0, false);
                    this.x.setVel(-d3);
                }
                if (d >= this.getMaxY()) {
                    this.y.doSetPos(this.getMaxY() - d6 - 20.0, false);
                    this.y.setVel(-d4);
                }
                if (d <= -this.getMaxY()) {
                    this.y.doSetPos(-this.getMaxY() - d6 + 20.0, false);
                    this.y.setVel(-d4);
                }
            } else if (this.wrapOn) {
                boolean bl = false;
                boolean bl2 = false;
                if (d2 == this.getMaxX()) {
                    this.x.setPos(-this.getMaxX());
                    bl = true;
                }
                if (!bl && d2 == -this.getMaxX()) {
                    this.x.setPos(this.getMaxX());
                    bl = true;
                }
                if (d == this.getMaxY()) {
                    this.y.setPos(-this.getMaxY());
                    bl2 = true;
                }
                if (!bl2 && d == -this.getMaxY()) {
                    this.y.setPos(this.getMaxY());
                    bl2 = true;
                }
                if (bl) {
                    this.paintBuf();
                    this.x.setPos(this.x.getPos() + this.x.getPosRemainder());
                }
                if (bl2) {
                    this.paintBuf();
                    this.y.setPos(this.y.getPos() + this.y.getPosRemainder());
                }
            } else {
                if (Math.abs(d2) == this.getMaxX()) {
                    this.x.getPosRemainder();
                }
                if (Math.abs(d) == this.getMaxY()) {
                    this.y.getPosRemainder();
                }
            }
            this.paintBuf();
            try {
                Thread.sleep(this.loopDelay);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Error sleeping.");
            }
            DotPanel dotPanel = this;
            synchronized (dotPanel) {
                try {
                    while (this.suspended) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Interrupted while waiting!");
                }
            }
        }
    }

    public boolean inEllipse() {
        return EtchUtils.inEllipse(this.x.getPos(), this.y.getPos(), this.width / 2, this.height / 2);
    }

    private Vector getDistVect(boolean bl) {
        double d = this.x.getPos();
        double d2 = this.y.getPos();
        Vector<Point> vector = new Vector<Point>();
        Enumeration enumeration = this.grav.elements();
        while (enumeration.hasMoreElements()) {
            Point point = (Point)enumeration.nextElement();
            if (bl) {
                vector.addElement(new Point((int)((double)point.x - d), (int)EtchUtils.dist(point.x, point.y, d, d2)));
                continue;
            }
            vector.addElement(new Point((int)((double)point.y - d2), (int)EtchUtils.dist(point.x, point.y, d, d2)));
        }
        return vector;
    }

    public void paintBuf() {
        double d;
        double d2;
        Graphics graphics;
        if (this.buf == null) {
            this.buf = this.createImage(this.width, this.height);
        }
        try {
            graphics = this.buf.getGraphics();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        graphics.clearRect(0, 0, this.width, this.height);
        this.myMode = this.x.getMode();
        graphics.drawString("Pos: (" + this.x.getPos() + "," + this.y.getPos() + ")", 5, 15);
        if (this.myMode != 1) {
            graphics.drawString("Vel: (" + this.x.getVel() + "," + this.y.getVel() + ")", 5, 30);
        }
        if (this.myMode == 3) {
            graphics.drawString("Accel: (" + this.x.getAccel() + "," + this.y.getAccel() + ")", 5, 45);
        }
        if (this.circMode) {
            graphics.setColor(Color.black);
            graphics.drawOval(0, 0, this.width, this.height);
            graphics.drawOval(this.focusA.x + this.width / 2 - 3, this.height / 2 - this.focusA.y - 3, 6, 6);
            graphics.drawOval(this.focusB.x + this.width / 2 - 3, this.height / 2 - this.focusB.y - 3, 6, 6);
        }
        graphics.setColor(Color.blue);
        Enumeration enumeration = this.grav.elements();
        while (enumeration.hasMoreElements()) {
            Point point = (Point)enumeration.nextElement();
            graphics.fillOval(point.x + this.width / 2 - 5, this.height / 2 - point.y - 5, 10, 10);
        }
        if (this.v.isEmpty()) {
            d2 = this.x.getPos();
            d = this.y.getPos();
            this.v.addElement(new Point((int)this.x.getPos(), (int)this.y.getPos()));
        } else {
            d2 = ((Point)this.v.elementAt((int)0)).x;
            d = ((Point)this.v.elementAt((int)0)).y;
        }
        Point point = new Point((int)this.x.getPos(), (int)this.y.getPos());
        Point point2 = (Point)this.v.lastElement();
        if (!((double)Math.abs(point.x - point2.x) < 1.0) || !((double)Math.abs(point.y - point2.y) < 1.0)) {
            this.v.addElement(point);
        }
        graphics.setColor(this.lineColor);
        Enumeration enumeration2 = this.v.elements();
        while (enumeration2.hasMoreElements()) {
            Point point3 = (Point)enumeration2.nextElement();
            if (Math.abs((double)point3.x - d2) < 2.0 * (this.getMaxX() - 10.0) && Math.abs((double)point3.y - d) < 2.0 * (this.getMaxY() - 10.0)) {
                graphics.drawLine((int)(d2 + (double)(this.width / 2)), (int)(-d + (double)(this.height / 2)), point3.x + this.width / 2, -point3.y + this.height / 2);
            }
            d2 = point3.x;
            d = point3.y;
        }
        graphics.setColor(this.dotColor);
        graphics.fillOval((int)(this.x.getPos() - 5.0 + (double)(this.width / 2)), (int)(-this.y.getPos() - 5.0 + (double)(this.height / 2)), 10, 10);
        this.repaint();
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        try {
            graphics.drawImage(this.buf, 0, 0, this);
        }
        catch (NullPointerException nullPointerException) {
            this.paintBuf();
        }
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
    }

    public void setDotColor(Color color) {
        this.dotColor = color;
    }

    public void setSize(int n, int n2) {
        this.buf = null;
        this.width = n;
        this.height = n2;
        this.x.setMaxPos(this.getMaxX());
        this.y.setMaxPos(this.getMaxY());
        this.paintBuf();
        super.setSize(n, n2);
    }

    public void flushLines() {
        this.v.removeAllElements();
        this.paintBuf();
    }

    public void addGrav(int n, int n2) {
        this.grav.addElement(new Point(n, n2));
    }

    public void setCirc(boolean bl) {
        this.circMode = bl;
        this.paintBuf();
    }

    public boolean getCirc() {
        return this.circMode;
    }

    public int curHeight() {
        return this.height;
    }

    public int curWidth() {
        return this.width;
    }

    public boolean getBounce() {
        return this.bounceOn;
    }

    public void setBounce(boolean bl) {
        this.bounceOn = bl;
    }

    public boolean getWrap() {
        return this.wrapOn;
    }

    public void setWrap(boolean bl) {
        this.wrapOn = bl;
    }
}

