/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;

public class ErrorConsole
extends JFrame {
    private int errorCount = 0;
    private StringBuffer errBuff = new StringBuffer();
    private JViewport vp;
    private JTextArea errorTextArea;
    private JPanel errorPanel;
    private JScrollPane errorScrollPane;

    public ErrorConsole() {
        this.initComponents();
    }

    private void initComponents() {
        this.errorPanel = new JPanel();
        this.errorScrollPane = new JScrollPane();
        this.errorTextArea = new JTextArea();
        this.setTitle("Etch-a-Sketch Error Messages");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ErrorConsole.this.exitForm(windowEvent);
            }
        });
        this.errorPanel.setLayout(new BorderLayout());
        this.errorPanel.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(new Insets(4, 4, 4, 4)), new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(3, 3, 3, 3)))), new BevelBorder(1)));
        this.errorScrollPane.setBorder(null);
        this.errorTextArea.setBackground(new Color(204, 204, 204));
        this.errorTextArea.setColumns(40);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setRows(10);
        this.errorTextArea.setTabSize(15);
        this.errorScrollPane.setViewportView(this.errorTextArea);
        this.errorPanel.add((Component)this.errorScrollPane, "Center");
        this.getContentPane().add((Component)this.errorPanel, "Center");
        this.pack();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.hide();
    }

    public void append(String string) {
        int n;
        this.vp = this.errorScrollPane.getViewport();
        int n2 = this.errorTextArea.getFontMetrics(this.errorTextArea.getFont()).getHeight();
        ++this.errorCount;
        this.errBuff.append("\n****** Error " + this.errorCount + " ******\n");
        this.errBuff.append(string);
        this.errorTextArea.setText(this.errBuff.toString());
        try {
            n = this.errorTextArea.getLineOfOffset(this.errorTextArea.getText().length() - 1);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("BadLocation from in error console:" + badLocationException);
        }
        this.vp.setViewPosition(new Point(0, n2 * n));
    }
}

