/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import etchasketch.AccelHandler;
import etchasketch.Accelerator;
import etchasketch.AdvEtchControls;
import etchasketch.Coord;
import etchasketch.DotFrame;
import etchasketch.Dummy;
import etchasketch.ErrorConsole;
import etchasketch.EtchControlListener;
import etchasketch.EtchHelp;
import etchasketch.EtchUtils;
import etchasketch.Recipe;
import etchasketch.RecipeView;
import etchasketch.ResetOptions;
import etchasketch.SoloRecipe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class EtchControl
extends JFrame {
    public static final int HEIGHT = 400;
    public static final int WIDTH = 400;
    public static final int BALLSIZE = 10;
    public static final int TIMESTEP = 100;
    public static final int GRAV = 1000;
    public static final double MAXVEL = 120.0;
    public static final int FOCUSSIZE = 6;
    public static final Font DEFAULTFONT = new Font("Plain", 0, 12);
    private static String xArg;
    private static String yArg;
    private static Thread xSpirit;
    private static Thread ySpirit;
    private static Accelerator xAccel;
    private static Accelerator yAccel;
    private static AccelHandler xHandler;
    private static AccelHandler yHandler;
    private static Coord xCoord;
    private static Coord yCoord;
    private boolean ready2Go = false;
    private boolean xStarted;
    private boolean yStarted;
    private boolean running = false;
    private static DotFrame myFrame;
    private AdvEtchControls myAdvEtchControls;
    private EtchHelp myHelp = new EtchHelp();
    private ResetOptions myResetOpts = new ResetOptions((Frame)this, false);
    private static ErrorConsole myErrors;
    private Recipe vert = new Recipe();
    private Recipe horz = new Recipe();
    private Vector listeners = new Vector();
    private ChangeEvent ce = new ChangeEvent(this);
    private JLabel titleLabel;
    private JMenuItem lineColorMenuItem;
    private JMenu drawingMenu;
    private JMenu recipeMenu;
    private JPanel titleLabelPanel;
    private JSeparator jSeparator2;
    private JMenuItem compileBothRecipeMenuItem;
    private JMenuItem standaloneRecipeMenuItem;
    private JMenu fileMenu;
    private JFileChooser myFileChooser;
    private JMenuItem backgroundColorMenuItem;
    private JCheckBoxMenuItem useHorzCheckBoxMenuItem;
    private RecipeView recipeViewVert;
    private JPanel ControlButtonPanel;
    private JButton stopButton;
    private JMenuItem exitMenuItem;
    private JMenuItem helpMenuItem;
    private JTabbedPane recipeTabs;
    private JPanel centerPanel;
    private JCheckBoxMenuItem useVertCheckBoxMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem errorConsoleMenuItem;
    private JMenuItem loadMenuItem;
    private JMenuItem advOptionsMenuItem;
    private JButton startButton;
    private JMenuBar menuBar;
    private JMenuItem newRecipe;
    private JMenuItem resetOptionsMenuItem;
    private JMenuItem dotColorMenuItem;
    private JButton newRecipeButton;
    private RecipeView recipeViewHorz;
    private JSeparator jSeparator1;
    private JButton resetButton;
    private JMenu helpMenu;
    private JMenuItem compileRecipeMenuItem;
    private JColorChooser myColorChooser;
    private JMenu drawingColorsMenu;

    private EtchControl() {
        xCoord.setOther(yCoord);
        yCoord.setOther(xCoord);
        this.initComponents();
        this.myFileChooser.setMultiSelectionEnabled(false);
        this.recipeViewVert.setRecipe(this.vert);
        this.addEtchControlListener(this.recipeViewVert);
        ((JTabbedPane)this.recipeViewVert.getParent()).setTitleAt(((JTabbedPane)this.recipeViewVert.getParent()).indexOfComponent(this.recipeViewVert), "Recipe " + this.recipeViewVert.getRecipeNum());
        this.recipeViewHorz.setRecipe(this.horz);
        this.addEtchControlListener(this.recipeViewHorz);
        ((JTabbedPane)this.recipeViewHorz.getParent()).setTitleAt(((JTabbedPane)this.recipeViewHorz.getParent()).indexOfComponent(this.recipeViewHorz), "Recipe " + this.recipeViewHorz.getRecipeNum());
        this.updateListeners();
        this.ready2Go = true;
        this.recipeTabsStateChanged(this.ce);
        myFrame = new DotFrame(xCoord, yCoord);
        this.myAdvEtchControls = new AdvEtchControls();
        this.myAdvEtchControls.setPanel(myFrame.getPanel());
    }

    private void initComponents() {
        this.myColorChooser = new JColorChooser();
        this.myFileChooser = new JFileChooser();
        this.titleLabelPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        this.recipeTabs = new JTabbedPane();
        this.recipeViewVert = new RecipeView();
        this.recipeViewHorz = new RecipeView();
        this.ControlButtonPanel = new JPanel();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.resetButton = new JButton();
        this.newRecipeButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newRecipe = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.loadMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.recipeMenu = new JMenu();
        this.useVertCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.useHorzCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator2 = new JSeparator();
        this.compileRecipeMenuItem = new JMenuItem();
        this.compileBothRecipeMenuItem = new JMenuItem();
        this.standaloneRecipeMenuItem = new JMenuItem();
        this.drawingMenu = new JMenu();
        this.resetOptionsMenuItem = new JMenuItem();
        this.errorConsoleMenuItem = new JMenuItem();
        this.drawingColorsMenu = new JMenu();
        this.dotColorMenuItem = new JMenuItem();
        this.lineColorMenuItem = new JMenuItem();
        this.backgroundColorMenuItem = new JMenuItem();
        this.advOptionsMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.setTitle("Etch-a-Sketch");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EtchControl.this.exitForm(windowEvent);
            }
        });
        this.titleLabelPanel.setMinimumSize(new Dimension(0, 0));
        this.titleLabelPanel.setPreferredSize(new Dimension(100, 25));
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("Etch-a-Sketch Controls");
        this.titleLabelPanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.titleLabelPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.centerPanel.setPreferredSize(new Dimension(801, 350));
        this.recipeTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EtchControl.this.recipeTabsStateChanged(changeEvent);
            }
        });
        this.recipeTabs.addTab("tab1", this.recipeViewVert);
        this.recipeTabs.addTab("tab2", this.recipeViewHorz);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerPanel.add((Component)this.recipeTabs, gridBagConstraints);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.ControlButtonPanel.setLayout(new GridLayout(2, 0));
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.startButtonActionPerformed(actionEvent);
            }
        });
        this.ControlButtonPanel.add(this.startButton);
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.stopButtonActionPerformed(actionEvent);
            }
        });
        this.ControlButtonPanel.add(this.stopButton);
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.ControlButtonPanel.add(this.resetButton);
        this.newRecipeButton.setText("New Recipe");
        this.newRecipeButton.setMargin(new Insets(2, 8, 2, 8));
        this.newRecipeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.newRecipeButtonActionPerformed(actionEvent);
            }
        });
        this.ControlButtonPanel.add(this.newRecipeButton);
        this.getContentPane().add((Component)this.ControlButtonPanel, "South");
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.fileMenuActionPerformed(actionEvent);
            }
        });
        this.newRecipe.setText("New Recipe");
        this.newRecipe.setToolTipText("Create a new Etch-a-Sketch Recipe");
        this.newRecipe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.newRecipeActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.newRecipe);
        this.saveMenuItem.setText("Save As...");
        this.saveMenuItem.setToolTipText("Save this recipe");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.saveMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.loadMenuItem.setText("Load Recipe...");
        this.loadMenuItem.setToolTipText("Load a recipie from a file");
        this.loadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.loadMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.setToolTipText("Exit the program");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.recipeMenu.setText("Recipe");
        this.recipeMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                EtchControl.this.recipeMenuMenuSelected(menuEvent);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        this.useVertCheckBoxMenuItem.setText("Use for Vertical");
        this.useVertCheckBoxMenuItem.setToolTipText("Use this rule to determine vertical position of the dot in the drawing window");
        this.useVertCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.useVertCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.recipeMenu.add(this.useVertCheckBoxMenuItem);
        this.useHorzCheckBoxMenuItem.setText("Use for Horizontal");
        this.useHorzCheckBoxMenuItem.setToolTipText("Use this rule to determine horizontal position of the dot in the drawing window");
        this.useHorzCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.useHorzCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.recipeMenu.add(this.useHorzCheckBoxMenuItem);
        this.recipeMenu.add(this.jSeparator2);
        this.compileRecipeMenuItem.setText("Compile");
        this.compileRecipeMenuItem.setToolTipText("Compile and load the code in this recipe");
        this.compileRecipeMenuItem.setEnabled(false);
        this.compileRecipeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.compileRecipeMenuItemActionPerformed(actionEvent);
            }
        });
        this.recipeMenu.add(this.compileRecipeMenuItem);
        this.compileBothRecipeMenuItem.setText("Compile Both");
        this.compileBothRecipeMenuItem.setToolTipText("Compile both vert and horz recipes");
        this.compileBothRecipeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.compileBothRecipeMenuItemActionPerformed(actionEvent);
            }
        });
        this.recipeMenu.add(this.compileBothRecipeMenuItem);
        this.standaloneRecipeMenuItem.setText("Standalone View");
        this.standaloneRecipeMenuItem.setToolTipText("View this recipe in it's own window");
        this.standaloneRecipeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.standaloneRecipeMenuItemActionPerformed(actionEvent);
            }
        });
        this.recipeMenu.add(this.standaloneRecipeMenuItem);
        this.menuBar.add(this.recipeMenu);
        this.drawingMenu.setText("Drawing");
        this.resetOptionsMenuItem.setText("Reset Options...");
        this.resetOptionsMenuItem.setToolTipText("Change the behavior of the reset button");
        this.resetOptionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.resetOptionsMenuItemActionPerformed(actionEvent);
            }
        });
        this.drawingMenu.add(this.resetOptionsMenuItem);
        this.errorConsoleMenuItem.setText("Error Console...");
        this.errorConsoleMenuItem.setToolTipText("Open a window to view error messages");
        this.errorConsoleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.errorConsoleMenuItemActionPerformed(actionEvent);
            }
        });
        this.drawingMenu.add(this.errorConsoleMenuItem);
        this.drawingColorsMenu.setText("Colors");
        this.dotColorMenuItem.setText("Dot");
        this.dotColorMenuItem.setToolTipText("Set the color of the dot");
        this.dotColorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.dotColorMenuItemActionPerformed(actionEvent);
            }
        });
        this.drawingColorsMenu.add(this.dotColorMenuItem);
        this.lineColorMenuItem.setText("Lines");
        this.lineColorMenuItem.setToolTipText("Set the color of the lines");
        this.lineColorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.lineColorMenuItemActionPerformed(actionEvent);
            }
        });
        this.drawingColorsMenu.add(this.lineColorMenuItem);
        this.backgroundColorMenuItem.setText("Background");
        this.backgroundColorMenuItem.setToolTipText("Set the background color");
        this.backgroundColorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.backgroundColorMenuItemActionPerformed(actionEvent);
            }
        });
        this.drawingColorsMenu.add(this.backgroundColorMenuItem);
        this.drawingMenu.add(this.drawingColorsMenu);
        this.advOptionsMenuItem.setText("Advanced Options...");
        this.advOptionsMenuItem.setToolTipText("Configure Advanced Etch-a-Sketch Options");
        this.advOptionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.advOptionsMenuItemActionPerformed(actionEvent);
            }
        });
        this.drawingMenu.add(this.advOptionsMenuItem);
        this.menuBar.add(this.drawingMenu);
        this.helpMenu.setText("Help");
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.setToolTipText("Get some help about using Etch-a-Sketch");
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EtchControl.this.helpMenuItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(400, 500));
        this.setLocation((dimension.width - 400) / 2, (dimension.height - 500) / 2);
    }

    private void loadMenuItemActionPerformed(ActionEvent actionEvent) {
        this.myFileChooser.showOpenDialog(this);
        try {
            File file = this.myFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.addTab(this.loadRecipe(file));
        }
        catch (IOException iOException) {
            EtchControl.errorMesg("Failed to load file! See the error console for details.", iOException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            EtchControl.errorMesg("Failed to load file! See the error console for details.", classNotFoundException.toString());
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.myFileChooser.showSaveDialog(this);
        try {
            File file = this.myFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists()) {
                int n = JOptionPane.showConfirmDialog(this, "Overwrite " + file.getName() + "?", "Confirm Overwrite", 2, 2);
                if (n == 0) {
                    this.saveRecipe(file, this.getCurrentRecipe());
                }
            } else {
                this.saveRecipe(file, this.getCurrentRecipe());
            }
        }
        catch (IOException iOException) {
            EtchControl.errorMesg("Failed to save file! See the error console for details.", iOException.toString());
        }
    }

    private void errorConsoleMenuItemActionPerformed(ActionEvent actionEvent) {
        myErrors.show();
    }

    private void backgroundColorMenuItemActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Set Background Color", Color.black);
        if (color != null) {
            myFrame.getPanel().setBackgroundColor(color);
        }
        myFrame.getPanel().paintBuf();
    }

    private void lineColorMenuItemActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Set Line Color", Color.black);
        if (color != null) {
            myFrame.getPanel().setLineColor(color);
        }
        myFrame.getPanel().paintBuf();
    }

    private void dotColorMenuItemActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Set Dot Color", Color.black);
        if (color != null) {
            myFrame.getPanel().setDotColor(color);
        }
        myFrame.getPanel().paintBuf();
    }

    private void resetOptionsMenuItemActionPerformed(ActionEvent actionEvent) {
        this.myResetOpts.setVisible(true);
    }

    private void helpMenuItemActionPerformed(ActionEvent actionEvent) {
        this.myHelp.show();
    }

    private void compileBothRecipeMenuItemActionPerformed(ActionEvent actionEvent) {
        EtchUtils.merge(yHandler, this.vert);
        this.vert.setCompiled(true);
        EtchUtils.merge(xHandler, this.horz);
        this.horz.setCompiled(true);
    }

    private void advOptionsMenuItemActionPerformed(ActionEvent actionEvent) {
        this.myAdvEtchControls.show();
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        boolean bl2 = (actionEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = bl2 && this.myResetOpts.isCtrlClickEnabled();
        if (bl || this.myResetOpts.isZeroVelocitySet()) {
            myFrame.stopDot();
        }
        if (bl || this.myResetOpts.isStopBallSet()) {
            this.stopButtonActionPerformed(actionEvent);
        }
        if (bl || this.myResetOpts.isCenterBallSet()) {
            myFrame.centerDot();
        }
        if (bl || this.myResetOpts.isClearAllLinesSet()) {
            myFrame.clearLines();
        }
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        this.running = true;
        xCoord.startSignal();
        yCoord.startSignal();
        if (this.xStarted) {
            xHandler.safeResume();
        } else {
            xSpirit.start();
            this.xStarted = true;
        }
        if (this.yStarted) {
            yHandler.safeResume();
        } else {
            ySpirit.start();
            this.yStarted = true;
        }
        myFrame.beginPainting();
    }

    private void standaloneRecipeMenuItemActionPerformed(ActionEvent actionEvent) {
        new SoloRecipe(((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe(), this, this.recipeTabs.getTitleAt(this.recipeTabs.getSelectedIndex())).show();
        this.updateListeners();
    }

    private void compileRecipeMenuItemActionPerformed(ActionEvent actionEvent) {
        Recipe recipe = ((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe();
        if (this.isHorzRecipe(recipe)) {
            EtchUtils.merge(xHandler, this.horz);
        }
        if (this.isVertRecipe(recipe)) {
            EtchUtils.merge(yHandler, this.vert);
        }
        ((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe().setCompiled(true);
    }

    private void recipeMenuMenuSelected(MenuEvent menuEvent) {
        boolean bl = !((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe().isCompiled();
        this.compileRecipeMenuItem.setEnabled(!this.running);
        boolean bl2 = !this.vert.isCompiled() || !this.horz.isCompiled();
        this.compileBothRecipeMenuItem.setEnabled(!this.running);
    }

    private void newRecipeButtonActionPerformed(ActionEvent actionEvent) {
        this.newRecipeActionPerformed(actionEvent);
    }

    private void newRecipeActionPerformed(ActionEvent actionEvent) {
        Recipe recipe = new Recipe();
        this.addTab(recipe);
    }

    private void useHorzCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.horz = this.useHorzCheckBoxMenuItem.getState() ? ((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe() : Recipe.nullRecipe;
        this.updateListeners();
    }

    private void useVertCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.vert = this.useVertCheckBoxMenuItem.getState() ? ((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe() : Recipe.nullRecipe;
        this.updateListeners();
    }

    private void recipeTabsStateChanged(ChangeEvent changeEvent) {
        if (!this.ready2Go) {
            return;
        }
        this.useHorzCheckBoxMenuItem.setState(this.isHorzRecipe(((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe()));
        this.useVertCheckBoxMenuItem.setState(this.isVertRecipe(((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe()));
        this.updateListeners();
    }

    private void stopButtonActionPerformed(ActionEvent actionEvent) {
        this.running = false;
        xHandler.safeSuspend();
        yHandler.safeSuspend();
        myFrame.suspendPainting();
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.exitForm(new WindowEvent(this, 201));
    }

    private void fileMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void exitForm(WindowEvent windowEvent) {
        myFrame.setVisible(false);
        myFrame.dispose();
        xHandler.safeStop();
        yHandler.safeStop();
        System.exit(0);
    }

    private Recipe loadRecipe(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        Recipe recipe = (Recipe)objectInputStream.readObject();
        objectInputStream.close();
        return recipe;
    }

    private void addTab(Recipe recipe) {
        RecipeView recipeView = new RecipeView();
        recipeView.setRecipe(recipe);
        this.addEtchControlListener(recipeView);
        this.recipeTabs.add(recipeView);
        ((JTabbedPane)recipeView.getParent()).setTitleAt(((JTabbedPane)recipeView.getParent()).indexOfComponent(recipeView), "Recipe " + recipeView.getRecipeNum());
        recipe.fireRecipeChanged();
        this.updateListeners();
    }

    private void saveRecipe(File file, Recipe recipe) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(recipe);
        objectOutputStream.close();
    }

    private Recipe getCurrentRecipe() {
        return ((RecipeView)this.recipeTabs.getSelectedComponent()).getRecipe();
    }

    public static void errorMesg(String string, String string2) {
        if (string != null) {
            JOptionPane.showMessageDialog(myFrame, string, "Etch-a-sketch Error", 0);
        }
        if (string2 != null) {
            myErrors.append(string2);
        }
    }

    public boolean isVertRecipe(Recipe recipe) {
        return recipe.getIdNum() == this.vert.getIdNum();
    }

    public boolean isHorzRecipe(Recipe recipe) {
        return recipe.getIdNum() == this.horz.getIdNum();
    }

    public void addEtchControlListener(EtchControlListener etchControlListener) {
        this.listeners.add(etchControlListener);
    }

    public void removeEtchControlListener(EtchControlListener etchControlListener) {
        this.listeners.remove(etchControlListener);
    }

    private void updateListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((EtchControlListener)this.listeners.get(i)).etchControlUpdated(this.ce);
        }
    }

    public static void setDrawDelay(int n) {
        myFrame.getPanel().setDelay(n);
    }

    public static void setYDelay(int n) {
        yHandler.setDelay(n);
    }

    public static void setXDelay(int n) {
        xHandler.setDelay(n);
    }

    public static void main(String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                xArg = null;
                yArg = null;
                break;
            }
            case 1: {
                xArg = stringArray[0];
                yArg = null;
                break;
            }
            case 2: {
                xArg = stringArray[0];
                yArg = stringArray[1];
                break;
            }
            default: {
                System.out.println("Only  0, 1, or 2 arguments accpeted.");
            }
        }
        if (xArg == null) {
            xAccel = new Dummy();
        } else {
            System.out.println("Trying to get class: " + xArg);
            xAccel = EtchUtils.createAccel(xArg);
        }
        if (yArg == null) {
            yAccel = new Dummy();
        } else {
            System.out.println("Trying to get class: " + yArg);
            yAccel = EtchUtils.createAccel(yArg);
        }
        if (xAccel == null || yAccel == null) {
            System.exit(0);
        }
        xHandler = new AccelHandler(xAccel, xCoord, yCoord);
        yHandler = new AccelHandler(yAccel, yCoord, xCoord);
        xSpirit = new Thread(xHandler);
        ySpirit = new Thread(yHandler);
        new EtchControl().show();
    }

    static {
        xCoord = new Coord();
        yCoord = new Coord();
        myErrors = new ErrorConsole();
    }
}

