/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;

public class EtchHelp
extends JFrame {
    TopicFinder finder = new TopicFinder();
    private JScrollPane helpScrollPane;
    private JLabel topicLabel3;
    private JLabel topicLabel8;
    private JPanel TopicsSidePanel;
    private JLabel topicLabel1;
    private JLabel topicLabel7;
    private JPanel topicPanel;
    private JLabel helpTitleLabel;
    private JLabel topicLabel6;
    private JPanel spacerPanel1;
    private JLabel topicLabel2;
    private JPanel helpTextPanel;
    private JTextArea helpTextArea;
    private JLabel topicLabel4;
    private JLabel topicLabel5;

    public EtchHelp() {
        this.initComponents();
    }

    private void initComponents() {
        this.helpTextPanel = new JPanel();
        this.helpScrollPane = new JScrollPane();
        this.helpTextArea = new JTextArea();
        this.TopicsSidePanel = new JPanel();
        this.helpTitleLabel = new JLabel();
        this.topicPanel = new JPanel();
        this.topicLabel1 = new JLabel();
        this.topicLabel2 = new JLabel();
        this.topicLabel3 = new JLabel();
        this.topicLabel4 = new JLabel();
        this.topicLabel5 = new JLabel();
        this.topicLabel6 = new JLabel();
        this.topicLabel7 = new JLabel();
        this.topicLabel8 = new JLabel();
        this.spacerPanel1 = new JPanel();
        this.setTitle("Etch-a-sketch Help");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EtchHelp.this.exitForm(windowEvent);
            }
        });
        this.helpTextPanel.setLayout(new GridLayout(1, 0));
        this.helpTextPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(8, 8, 8, 8)), new BevelBorder(1)));
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setText("* Moving the Dot *\n---------------\n\nThere are three steps to making the \ndot move. These are esentially the \nsame steps needed to run any Java \nprogram.\n\n1.) Enter some (valid) java code in\none of the text areas of one of the\ntwo recipes available at start up.\nThe code you enter must call a return\nstatement. The value of the first \nreturn statement executed will be\nused to position the dot in the\ndirection indicated for this recipe.\n(one should say Vertical in green\nat the bottom, the other should\nsay Horizontal in magenta)\n\n2.) Compile the code you entered.\nThis is done by mousing to the\nmenu bar and selecting\nRecipe > Compile.\nThe currently selected Recipe \nwill be compile, if it is currently used\nas a horizontal rule, a vertical rule,\nor for both rules.\n\n3.) Run the code by pressing the\nlarge button labeled \"Start\"\n\n\n* Parameters * \n------------\n\n(System provided names)\n\nIn your code, you may make use of the \nfollowing names, which are of type \ndouble:\n\n  * pos    -    \tthe position of the dot \n\talong the axis where \n\tthis rule applies.\n  * vel     -    \tthe velocity of the dot \n\talong the axis where this \n\trule applies.\n  * otherPos -\tthe position of the dot \n\talong the other axis.\n  * otherVel -\tthe velocity of the dot \n\talong the axis.\n  * maxPos -\tthe maximum and \n\tminimumallowable \n\tpositions for the dot \n\talong the axis where \n\tthis rule applies.  \n\t+maxPos represents \n\tthe rightmost (or \n\ttopmost) edge of the \n\tSpirograph, and \n\t-maxPos represents\n\tthe leftmost (or \n\tbottommost) edge of the \n\tSpirograph.\n\nFor example, if a rule is being used as\nthe horizontal rule, then pos would \nreturn its x coordinate, and vel would \nreturn its velocity in the x direction.\n\nYou can use these names to return \nvalues that depend on your position.\n\n\n* Parameters Example *\n--------------------\n\nIn Position Mode:\n\nTo make the dot move to the \ncoordinates (0,100) and then drift right\nslowly use :\n\nHorizontal:\n\nif (otherPos == 0.0) {\n   return 0;\n} else {\n   pos = pos + 1;\n   return pos;\n}\n\nVertical:\n\nreturn 100;\n");
        this.helpTextArea.setCaretPosition(1);
        this.helpTextArea.setMargin(new Insets(0, 5, 0, 5));
        this.helpScrollPane.setViewportView(this.helpTextArea);
        this.helpTextPanel.add(this.helpScrollPane);
        this.getContentPane().add((Component)this.helpTextPanel, "Center");
        this.TopicsSidePanel.setLayout(new GridBagLayout());
        this.TopicsSidePanel.setBorder(new EmptyBorder(new Insets(0, 3, 0, 0)));
        this.helpTitleLabel.setFont(new Font("Dialog", 1, 18));
        this.helpTitleLabel.setHorizontalAlignment(0);
        this.helpTitleLabel.setText("Etch-a-sketch Help");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.TopicsSidePanel.add((Component)this.helpTitleLabel, gridBagConstraints);
        this.topicPanel.setLayout(new GridBagLayout());
        this.topicPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(0, 8, 8, 8)), new TitledBorder(null, "Help Topics", 0, 0, new Font("Dialog", 0, 10))));
        this.topicLabel1.setText("Moving the Dot");
        this.topicLabel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.topicPanel.add((Component)this.topicLabel1, gridBagConstraints);
        this.topicLabel2.setHorizontalAlignment(2);
        this.topicLabel2.setText("Parameters");
        this.topicLabel2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.topicPanel.add((Component)this.topicLabel2, gridBagConstraints);
        this.topicLabel3.setFont(new Font("Dialog", 0, 12));
        this.topicLabel3.setHorizontalAlignment(2);
        this.topicLabel3.setText("pos");
        this.topicLabel3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.topicPanel.add((Component)this.topicLabel3, gridBagConstraints);
        this.topicLabel4.setFont(new Font("Dialog", 0, 12));
        this.topicLabel4.setHorizontalAlignment(2);
        this.topicLabel4.setText("vel");
        this.topicLabel4.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.topicPanel.add((Component)this.topicLabel4, gridBagConstraints);
        this.topicLabel5.setFont(new Font("Dialog", 0, 12));
        this.topicLabel5.setHorizontalAlignment(2);
        this.topicLabel5.setText("otherPos");
        this.topicLabel5.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.topicPanel.add((Component)this.topicLabel5, gridBagConstraints);
        this.topicLabel6.setFont(new Font("Dialog", 0, 12));
        this.topicLabel6.setHorizontalAlignment(2);
        this.topicLabel6.setText("otherVel");
        this.topicLabel6.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.topicPanel.add((Component)this.topicLabel6, gridBagConstraints);
        this.topicLabel7.setFont(new Font("Dialog", 0, 12));
        this.topicLabel7.setHorizontalAlignment(2);
        this.topicLabel7.setText("maxPos");
        this.topicLabel7.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.topicPanel.add((Component)this.topicLabel7, gridBagConstraints);
        this.topicLabel8.setText("Parameters Example");
        this.topicLabel8.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EtchHelp.this.find(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                EtchHelp.this.unhighlight(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                EtchHelp.this.highlight(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.topicPanel.add((Component)this.topicLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topicPanel.add((Component)this.spacerPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.TopicsSidePanel.add((Component)this.topicPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.TopicsSidePanel, "West");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(490, 300));
        this.setLocation((dimension.width - 490) / 2, (dimension.height - 300) / 2);
    }

    private void unhighlight(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setForeground(Color.black);
    }

    private void highlight(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setForeground(Color.blue);
    }

    private void find(MouseEvent mouseEvent) {
        this.finder.mouseClicked(mouseEvent);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.hide();
    }

    private class TopicFinder
    extends MouseAdapter {
        private TopicFinder() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = this.findHeader(((JLabel)mouseEvent.getSource()).getText());
            try {
                n = EtchHelp.this.helpTextArea.getLineOfOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("BadLocation from findHeader:" + badLocationException);
            }
            int n3 = EtchHelp.this.helpTextArea.getFontMetrics(EtchHelp.this.helpTextArea.getFont()).getHeight();
            JViewport jViewport = EtchHelp.this.helpScrollPane.getViewport();
            jViewport.setViewPosition(new Point(0, n3 * n));
        }

        private int findHeader(String string) {
            return EtchHelp.this.helpTextArea.getText().indexOf("* " + string);
        }
    }
}

