/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import etchasketch.Barrier;
import etchasketch.DotPoint;
import etchasketch.EtchUtils;
import etchasketch.Impact;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class OrthoRectBorder
implements Barrier {
    public static final int MODE_STICKY = 0;
    public static final int MODE_BOUNCE = 1;
    public static final int MODE_WRAP = 2;
    private double height;
    private double width;
    private DotPoint rectCenter;
    private int mode = 0;

    public OrthoRectBorder() {
        this.setCenter(0.0, 0.0);
    }

    public OrthoRectBorder(int n, int n2) {
        this.setCenter(0.0, 0.0);
        this.setHeight(n);
        this.setWidth(n2);
    }

    public OrthoRectBorder(double d, double d2) {
        this.setCenter(0.0, 0.0);
        this.setHeight(d);
        this.setWidth(d2);
    }

    public void drawSelf(Graphics graphics, Point point) {
        int n = (int)(this.rectCenter.getX() - this.width / 2.0 + point.getX());
        int n2 = (int)(this.rectCenter.getY() + this.height / 2.0 + point.getY());
        graphics.drawRect(n, n2, (int)this.width, (int)this.height);
    }

    public Impact checkImpact(DotPoint dotPoint, DotPoint dotPoint2, double d, double d2) {
        Impact impact = null;
        Vector vector = this.findIntersections(dotPoint, dotPoint2);
        if (vector.size() == 0) {
            return impact;
        }
        DotPoint dotPoint3 = this.firstIntersection(vector, dotPoint, dotPoint2);
        switch (this.mode) {
            case 0: {
                if (dotPoint3.getX() == this.getMaxX() && dotPoint3.getY() == this.getMaxY() || dotPoint3.getX() == this.getMaxX() && dotPoint3.getY() == this.getMinY() || dotPoint3.getX() == this.getMinX() && dotPoint3.getY() == this.getMaxY() || dotPoint3.getX() == this.getMinX() && dotPoint3.getY() == this.getMinY()) {
                    DotPoint dotPoint4 = dotPoint3;
                    return new Impact(dotPoint, dotPoint2, dotPoint3, dotPoint4, 0.0, 0.0);
                }
                if (dotPoint3.getX() == this.getMaxX() || dotPoint3.getX() == this.getMinX()) {
                    DotPoint dotPoint5 = new DotPoint(dotPoint3.getX(), dotPoint2.getY());
                    return new Impact(dotPoint, dotPoint2, dotPoint3, dotPoint5, 0.0, d2);
                }
                if (dotPoint3.getY() != this.getMaxY() && dotPoint3.getY() != this.getMinY()) break;
                DotPoint dotPoint6 = new DotPoint(dotPoint2.getX(), dotPoint3.getY());
                return new Impact(dotPoint, dotPoint2, dotPoint3, dotPoint6, d, 0.0);
            }
            case 1: {
                break;
            }
        }
        return impact;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setCenter(double d, double d2) {
        this.rectCenter.setX(d);
        this.rectCenter.setY(d2);
    }

    public void setMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.mode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a legal mode for OrthoRectBorder");
            }
        }
    }

    private double getMaxX() {
        return this.rectCenter.getX() + this.width / 2.0;
    }

    private double getMaxY() {
        return this.rectCenter.getY() + this.height / 2.0;
    }

    private double getMinX() {
        return this.rectCenter.getX() - this.width / 2.0;
    }

    private double getMinY() {
        return this.rectCenter.getY() - this.height / 2.0;
    }

    private Vector findIntersections(DotPoint dotPoint, DotPoint dotPoint2) {
        Vector<DotPoint> vector = new Vector<DotPoint>();
        double d = (dotPoint2.getY() - dotPoint.getY()) / (dotPoint2.getX() - dotPoint.getX());
        double d2 = dotPoint.getY() - d * dotPoint.getX();
        if (!Double.isNaN(d) && dotPoint.getX() < this.getMaxX() && dotPoint2.getX() > this.getMaxX()) {
            vector.add(new DotPoint(this.getMaxX(), d * this.getMaxX() + d2));
        }
        if (!Double.isNaN(d) && dotPoint.getX() > this.getMinX() && dotPoint2.getX() < this.getMinX()) {
            vector.add(new DotPoint(this.getMinX(), d * this.getMinX() + d2));
        }
        if (d != 0.0 && dotPoint.getY() < this.getMaxY() && dotPoint2.getY() > this.getMaxY()) {
            vector.add(new DotPoint((this.getMaxY() - d2) / d, this.getMaxY()));
        }
        if (d != 0.0 && dotPoint.getY() > this.getMinY() && dotPoint2.getY() < this.getMinY()) {
            vector.add(new DotPoint((this.getMinY() - d2) / d, this.getMinY()));
        }
        return vector;
    }

    private DotPoint firstIntersection(Vector vector, DotPoint dotPoint, DotPoint dotPoint2) {
        if (vector.size() == 0) {
            throw new IllegalArgumentException("Empty vector of points!");
        }
        DotPoint dotPoint3 = (DotPoint)vector.get(0);
        double d = EtchUtils.dist(dotPoint.getX(), dotPoint.getY(), dotPoint3.getX(), dotPoint3.getY());
        for (int i = 0; i < vector.size(); ++i) {
            DotPoint dotPoint4 = (DotPoint)vector.get(i);
            double d2 = EtchUtils.dist(dotPoint.getX(), dotPoint.getY(), dotPoint4.getX(), dotPoint4.getY());
            if (!(d2 < d) || !this.inBox(dotPoint, dotPoint2, dotPoint4)) continue;
            dotPoint3 = dotPoint4;
            d = d2;
        }
        return dotPoint3;
    }

    private boolean inBox(DotPoint dotPoint, DotPoint dotPoint2, DotPoint dotPoint3) {
        return (dotPoint.getX() > dotPoint3.getX() && dotPoint2.getX() < dotPoint3.getX() || dotPoint2.getX() > dotPoint3.getX() && dotPoint.getX() < dotPoint3.getX()) && dotPoint.getY() > dotPoint3.getY() && dotPoint2.getY() < dotPoint3.getY() || dotPoint2.getY() > dotPoint3.getY() && dotPoint.getY() < dotPoint3.getY();
    }
}

