/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import etchasketch.CodeSource;
import etchasketch.RecipeListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;

public class Recipe
implements Serializable,
ObjectInputValidation,
CodeSource {
    private static int instances = 0;
    private transient int idNum;
    public static final Recipe nullRecipe = new Recipe();
    private transient ChangeEvent ce = new ChangeEvent(this);
    private transient Vector listeners = new Vector();
    private String fields = "";
    private String code = "";
    private boolean compiled = true;

    public Recipe() {
        this.idNum = instances++;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.registerValidation(this, 0);
        objectInputStream.defaultReadObject();
        this.idNum = instances++;
        this.listeners = new Vector();
        this.ce = new ChangeEvent(this);
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public int getIdNum() {
        return this.idNum;
    }

    public String getCode() {
        return this.code;
    }

    public String getFields() {
        return this.fields;
    }

    public void setCompiled(boolean bl) {
        this.compiled = bl;
        this.updateListeners();
    }

    public void setCode(String string) throws UnsupportedOperationException {
        if (this == nullRecipe) {
            throw new UnsupportedOperationException("Cannot modify the \"null recipe!\"");
        }
        this.code = string;
        this.compiled = false;
        this.updateListeners();
    }

    public void setFields(String string) throws UnsupportedOperationException {
        if (this == nullRecipe) {
            throw new UnsupportedOperationException("Cannot modify the \"null recipe!\"");
        }
        this.fields = string;
        this.compiled = false;
        this.updateListeners();
    }

    public void addRecipeListener(RecipeListener recipeListener) {
        this.listeners.add(recipeListener);
    }

    public void removeRecipeListener(RecipeListener recipeListener) {
        this.listeners.remove(recipeListener);
    }

    public void fireRecipeChanged() {
        this.updateListeners();
    }

    private void updateListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((RecipeListener)this.listeners.get(i)).recipeUpdated(this.ce);
        }
    }

    public void validateObject() throws InvalidObjectException {
        if (this.ce == null || this.ce.getSource() != this) {
            throw new InvalidObjectException("Change event didn't initilaize properly");
        }
        if (this.listeners == null) {
            throw new InvalidObjectException("Listener vector failed to initialize");
        }
        if (this.idNum == 0) {
            throw new InvalidObjectException("ID=0 did you serialize the nullRecipe?");
        }
    }
}

