/*
 * Decompiled with CFR 0.152.
 */
package etchasketch;

import etchasketch.EtchControl;
import etchasketch.EtchControlListener;
import etchasketch.Recipe;
import etchasketch.RecipeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;

public class RecipeView
extends JPanel
implements RecipeListener,
EtchControlListener {
    private JTextArea statementTextArea;
    private JPanel hvCheckPanel;
    private JPanel statementPanel;
    private JLabel statementLabel;
    private JScrollPane statementScrollPane;
    private JPanel fieldPanel;
    private JLabel fieldLabel;
    private JTextArea fieldTextArea;
    private JScrollPane fieldScrollPane;
    private JToggleButton fieldsToggleButton;
    private JPanel recipeButtonPanel;
    private JPanel recipeControlPanel;
    private JLabel statusHeaderLabel;
    private JLabel statusLabel;
    private JLabel compileLabel;
    private Recipe theRecipe = Recipe.nullRecipe;

    public RecipeView() {
        this.initComponents();
        this.setBorder(new EtchedBorder());
    }

    private void initComponents() {
        this.fieldPanel = new JPanel();
        this.fieldPanel.setVisible(false);
        this.fieldLabel = new JLabel();
        this.fieldScrollPane = new JScrollPane();
        this.fieldTextArea = new JTextArea();
        this.statementPanel = new JPanel();
        this.statementLabel = new JLabel();
        this.statementScrollPane = new JScrollPane();
        this.statementTextArea = new JTextArea();
        this.recipeControlPanel = new JPanel();
        this.recipeButtonPanel = new JPanel();
        this.fieldsToggleButton = new JToggleButton();
        this.hvCheckPanel = new JPanel();
        this.statusHeaderLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.compileLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.fieldPanel.setLayout(new BorderLayout());
        this.fieldLabel.setText("Enter your Recipe Fields Here");
        this.fieldLabel.setBorder(new EmptyBorder(new Insets(1, 1, 5, 1)));
        this.fieldPanel.add((Component)this.fieldLabel, "North");
        this.fieldTextArea.setColumns(30);
        this.fieldTextArea.setRows(4);
        this.fieldTextArea.setBorder(new BevelBorder(1));
        this.fieldTextArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                RecipeView.this.fieldTextAreaKeyReleased(keyEvent);
            }
        });
        this.fieldScrollPane.setViewportView(this.fieldTextArea);
        this.fieldPanel.add((Component)this.fieldScrollPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.fieldPanel, gridBagConstraints);
        this.statementPanel.setLayout(new BorderLayout());
        this.statementLabel.setText("Enter a Recipe Below");
        this.statementLabel.setBorder(new EmptyBorder(new Insets(10, 1, 5, 1)));
        this.statementPanel.add((Component)this.statementLabel, "North");
        this.statementTextArea.setColumns(30);
        this.statementTextArea.setRows(8);
        this.statementTextArea.setBorder(new BevelBorder(1));
        this.statementTextArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                RecipeView.this.statementTextAreaKeyReleased(keyEvent);
            }
        });
        this.statementScrollPane.setViewportView(this.statementTextArea);
        this.statementPanel.add((Component)this.statementScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.statementPanel, gridBagConstraints);
        this.recipeControlPanel.setLayout(new GridBagLayout());
        this.recipeButtonPanel.setLayout(new GridBagLayout());
        this.fieldsToggleButton.setText("Add Fields");
        this.fieldsToggleButton.setToolTipText("Click to hide or unhide the fields box");
        this.fieldsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecipeView.this.fieldsToggleButtonActionPerfomred(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.recipeButtonPanel.add((Component)this.fieldsToggleButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.recipeControlPanel.add((Component)this.recipeButtonPanel, gridBagConstraints);
        this.hvCheckPanel.setLayout(new GridBagLayout());
        this.statusHeaderLabel.setText("This recipe used for");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        this.hvCheckPanel.add((Component)this.statusHeaderLabel, gridBagConstraints);
        this.statusLabel.setText("None");
        this.statusLabel.setFont(new Font("Dialog", 1, 16));
        this.statusLabel.setForeground(Color.red);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        this.hvCheckPanel.add((Component)this.statusLabel, gridBagConstraints);
        this.compileLabel.setText("< " + (this.theRecipe.isCompiled() ? "" : "Not ") + "Compiled >");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        this.hvCheckPanel.add((Component)this.compileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.recipeControlPanel.add((Component)this.hvCheckPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.recipeControlPanel, gridBagConstraints);
    }

    private void fieldTextAreaKeyReleased(KeyEvent keyEvent) {
        this.theRecipe.setFields(this.fieldTextArea.getText());
    }

    private void statementTextAreaKeyReleased(KeyEvent keyEvent) {
        this.theRecipe.setCode(this.statementTextArea.getText());
    }

    private void fieldsToggleButtonActionPerfomred(ActionEvent actionEvent) {
        this.fieldPanel.setVisible(!this.fieldPanel.isVisible());
    }

    public void etchControlUpdated(ChangeEvent changeEvent) {
        boolean bl = ((EtchControl)changeEvent.getSource()).isVertRecipe(this.theRecipe);
        boolean bl2 = ((EtchControl)changeEvent.getSource()).isHorzRecipe(this.theRecipe);
        if (bl && bl2) {
            this.statusLabel.setText("Both");
            this.statusLabel.setForeground(Color.blue);
            if (this.getParent() instanceof JTabbedPane) {
                ((JTabbedPane)this.getParent()).setForegroundAt(((JTabbedPane)this.getParent()).indexOfComponent(this), Color.blue);
                ((JTabbedPane)this.getParent()).setToolTipTextAt(((JTabbedPane)this.getParent()).indexOfComponent(this), "The recipe currently used for both vertical and horizontal positioning of the dot");
            }
        }
        if (bl && !bl2) {
            this.statusLabel.setText("Vertical");
            this.statusLabel.setForeground(new Color(0, 128, 0));
            if (this.getParent() instanceof JTabbedPane) {
                ((JTabbedPane)this.getParent()).setForegroundAt(((JTabbedPane)this.getParent()).indexOfComponent(this), new Color(0, 128, 0));
                ((JTabbedPane)this.getParent()).setToolTipTextAt(((JTabbedPane)this.getParent()).indexOfComponent(this), "The recipe currently used for vertical positioning of the dot");
            }
        }
        if (!bl && bl2) {
            this.statusLabel.setText("Horizontal");
            this.statusLabel.setForeground(Color.magenta);
            if (this.getParent() instanceof JTabbedPane) {
                ((JTabbedPane)this.getParent()).setForegroundAt(((JTabbedPane)this.getParent()).indexOfComponent(this), Color.magenta);
                ((JTabbedPane)this.getParent()).setToolTipTextAt(((JTabbedPane)this.getParent()).indexOfComponent(this), "The recipe currently used for horizontal positioning of the dot");
            }
        }
        if (!bl && !bl2) {
            this.statusLabel.setText("None");
            this.statusLabel.setForeground(Color.red);
            if (this.getParent() instanceof JTabbedPane) {
                ((JTabbedPane)this.getParent()).setForegroundAt(((JTabbedPane)this.getParent()).indexOfComponent(this), Color.black);
                ((JTabbedPane)this.getParent()).setToolTipTextAt(((JTabbedPane)this.getParent()).indexOfComponent(this), "A recipe not currently in use");
            }
        }
    }

    public void recipeUpdated(ChangeEvent changeEvent) {
        this.compileLabel.setText("< " + (this.theRecipe.isCompiled() ? "" : "Not ") + "Compiled >");
        int n = this.statementTextArea.getCaretPosition();
        this.statementTextArea.setText(((Recipe)changeEvent.getSource()).getCode());
        this.statementTextArea.setCaretPosition(n);
        n = this.fieldTextArea.getCaretPosition();
        this.fieldTextArea.setText(((Recipe)changeEvent.getSource()).getFields());
        this.fieldTextArea.setCaretPosition(n);
    }

    public void setRecipe(Recipe recipe) {
        this.theRecipe = recipe;
        recipe.addRecipeListener(this);
    }

    public Recipe getRecipe() {
        return this.theRecipe;
    }

    public int getRecipeNum() {
        return this.theRecipe.getIdNum();
    }
}

